

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "'s tags": "'s tags",
    "(If left blank, owner will be admin)": " (Sans autre sp\u00e9cification, l'utilisateur actuel devient le propri\u00e9taire.)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(au moins {passwordMinLength} caract\u00e8res et {passwordStrengthLevel} exemplaires des caract\u00e8res suivant: nombres, majuscules, minuscules et caract\u00e8res sp\u00e9ciaux)",
    "(at least {placeholder} characters)": "(au moins {placeholder} caract\u00e8res)",
    "(current notification)": " (notification actuelle)",
    "(current version)": "(version actuelle)",
    "(deleted)": "(supprim\u00e9)",
    "1 Year": "1 an",
    "1 cell copied": "1 cellule a \u00e9t\u00e9 copi\u00e9e dans le presse-papiers.",
    "1 cell cut": "1 cellule a \u00e9t\u00e9 coup\u00e9e et copi\u00e9e dans le presse-papiers.",
    "1 filter": "1 filtre",
    "1 hidden property": "1 propri\u00e9t\u00e9 masqu\u00e9e",
    "1 month ago": "Il y a 1 mois",
    "1 preset hidden property": "1 propri\u00e9t\u00e9 masqu\u00e9e pr\u00e9d\u00e9finie",
    "1 record selected": "1 enregistrement s\u00e9lectionn\u00e9",
    "1 row is copied.": "1 ligne a \u00e9t\u00e9 copi\u00e9e dans le presse-papiers.",
    "1 sort": "1 tri",
    "1 week ago": "Il y a 1 semaine",
    "3 days ago": "Il y a 3 jours",
    "30 Days": "30 jours",
    "7 Days": "7 jours",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un fichier a \u00e9t\u00e9 mis \u00e0 jour. \u00cates-vous certain de vouloir quitter cette page?",
    "A file with the same name already exists in this folder.": "Un fichier avec un nom identique existe d\u00e9j\u00e0 dans ce dossier.",
    "API Token": "Token API",
    "API token is copied to the clipboard.": "Le token API est copi\u00e9 dans le presse-papiers.",
    "About": "\u00c0 propos",
    "About Us": "\u00c0 propos de nous",
    "Abuse Content": "Contenu de l'abus",
    "Abuse Reports": "Rapports d'abus",
    "Abuse Type": "Type d'abus",
    "Abuse report added": "Un rapport abus a \u00e9t\u00e9 ajout\u00e9.",
    "Accept": "Accepter",
    "Accepted": "Accept\u00e9es",
    "Accepted at": "Accept\u00e9 \u00e0",
    "Accepter": "Accepter",
    "Access Log": "Fichier journaux",
    "Access scope": "Port\u00e9e de l'acc\u00e8s",
    "Accurate to minute": "Pr\u00e9cis \u00e0 la minute",
    "Action": "Action",
    "Actions": "Actions",
    "Activate after registration": "Auto-activer des inscriptions",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activer l'utilisateur imm\u00e9diatement apr\u00e8s l'inscription. Si c'est d\u00e9coch\u00e9, l'utilisateur devra \u00eatre activ\u00e9 par un administrateur ou via e-mail.",
    "Activated": "Activ\u00e9",
    "Activated Users": "Utilisateurs actifs",
    "Active": "Actif",
    "Active Users": "Utilisateurs actifs",
    "Active users": "Utilisateurs actifs",
    "Activities": "Activit\u00e9s",
    "Add": "Ajouter",
    "Add Admin": "Ajouter un administrateur",
    "Add Admins": "Ajouter des administrateurs",
    "Add Folder": "Ajouter un dossier",
    "Add Institution": "Ajouter institution",
    "Add Library": "Ajouter une biblioth\u00e8que",
    "Add Member": "Ajouter un membre",
    "Add Organization": "Ajouter une Organisation",
    "Add Terms and Conditions": "Ajouter des conditions d'utilisation",
    "Add User": "Ajouter un utilisateur",
    "Add Wiki": "Ajouter un wiki",
    "Add admin": "Ajouter un administrateur",
    "Add auto expiration": "Ajouter une date d'expiration",
    "Add child tags": "Ajouter un tag enfant",
    "Add cover": "Ajouter une couverture",
    "Add custom permission": "Ajouter un droit personnalis\u00e9",
    "Add department at": "Ajouter un d\u00e9partement \u00e0",
    "Add filter": "filtres",
    "Add group": "Ajouter un groupe",
    "Add group member": "Ajouter un membre au groupe",
    "Add icon": "Ajouter une ic\u00f4ne",
    "Add institution": "Ajouter une institution",
    "Add members": "Ajouter des membres",
    "Add new notification": "Ajouter une notification",
    "Add option": "Ajouter une option",
    "Add page": "Ajouter une page",
    "Add page above": "Ajouter une page au-dessus",
    "Add page below": "Ajouter une page en-dessous",
    "Add page inside": "Ajouter une page \u00e0 l'int\u00e9rieur",
    "Add password protection": "Ajouter un mot de passe",
    "Add permission": "Ajouter un droit",
    "Add sort": "Ajouter un tri",
    "Add sub-department": "Ajouter un sous-d\u00e9partement",
    "Add tag": "Ajouter un tag",
    "Add to group": "Ajouter au groupe",
    "Add user": "Ajouter un utilisateur",
    "Add view": "Ajouter une vue",
    "Added": "Ajout\u00e9",
    "Added user {user}": "Utilisateur {user} ajout\u00e9",
    "Admin": "Administration",
    "Admin Login Logs": "Logs de connexion d'aministrateur",
    "Admin Logs": "Logs admin",
    "Admin Operation Logs": "Logs d'op\u00e9rations administrateur",
    "Admin access": "Acc\u00e8s administrateur",
    "Admin updated": "L'administrateur a \u00e9t\u00e9 mis \u00e0 jour.",
    "Admins": "Administrateurs",
    "Advanced": "Avanc\u00e9",
    "After enable OCR, you can extract text from images or scanned PDFs.": "L'activation de l'OCR permet d'extraire du texte \u00e0 partir des images ou des PDF num\u00e9ris\u00e9s.",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Lorsque vous activez les propri\u00e9t\u00e9s \u00e9tendues, vous pouvez ajouter diff\u00e9rentes propri\u00e9t\u00e9s aux fichiers, comme les collaborateurs, la date d'expiration du fichier, la description du fichier. Vous pouvez \u00e9galement cr\u00e9er diff\u00e9rentes vues pour les fichiers en fonction des propri\u00e9t\u00e9s \u00e9tendues.",
    "All": "Toutes",
    "All Activities": "Toutes les activit\u00e9s",
    "All Groups": "Mes groupes",
    "All Notifications": "Toutes les notifications",
    "All Public Links": "Tous les liens publics",
    "All files uploaded": "Tous les fichiers ont \u00e9t\u00e9s envoy\u00e9s",
    "All records loaded": "Tous enregistrements ont \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9s.",
    "All tags": "Tous les tags",
    "Allow new registrations": "Autoriser les inscriptions des nouveaux utilisateurs",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Autoriser les inscriptions des nouveaux utilisateurs. D\u00e9cochez ceci afin d'\u00e9viter que n'importe qui puisse cr\u00e9er un nouveau compte.",
    "Allow users to change library history settings": "Autoriser les utilisateurs \u00e0 modifier les param\u00e8tres de l'historique de la biblioth\u00e8que",
    "Allow users to clean library trash": "Autoriser les utilisateurs \u00e0 nettoyer les corbeilles de la biblioth\u00e8que",
    "Allow users to create encrypted libraries": "Autoriser les utilisateurs \u00e0 c\u0155eer des biblioth\u00e8ques chiffr\u00e9es",
    "An integer that is greater than 0 or equal to -2.": "Un nombre entier sup\u00e9rieur \u00e0 0 ou \u00e9gal \u00e0 -2.",
    "An integer that is greater than or equal to 0.": "Un entier sup\u00e9rieur ou \u00e9gal \u00e0 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un lien interne est un lien vers un fichier ou un dossier accessible en lecture par un utilisateur.",
    "And": "et",
    "Anonymous User": "Utilisateur anonyme",
    "Another property has this property type": "Une autre colonne a ce type de colonne.",
    "Another user is editing this file!": "Un autre utilisateur est en train de modifier le fichier.",
    "Anyone with the link": "Toute personne ayant le lien",
    "App Name": "Nom de l'application",
    "Are you sure to change group {placeholder} to department ?": "\u00cates-vous s\u00fbr de vouloir convertir le groupe {placeholder} en d\u00e9partement?",
    "Are you sure to delete": "\u00cates-vous certain de vouloir supprimer ?",
    "Are you sure to delete ": "\u00cates-vous s\u00fbr de vouloir supprimer",
    "Are you sure to revoke access of user {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9voquer l'acc\u00e8s \u00e0 l\u2019utilisateur {placeholder}?",
    "Are you sure you want to clean invalid share links?": "\u00cates-vous certain de vouloir supprimer les liens de t\u00e9l\u00e9chargement invalides?",
    "Are you sure you want to clean invalid upload links?": "\u00cates-vous certain de vouloir supprimer les liens d'envoiv invalides?",
    "Are you sure you want to clear trash?": "\u00cates-vous certain de vouloir vider la corbeille?",
    "Are you sure you want to delete": "\u00cates-vous s\u00fbr de vouloir supprimer",
    "Are you sure you want to delete %s ?": "\u00cates-vous certain de vouloir supprimer %s?",
    "Are you sure you want to delete WebDAV password?": "\u00cates-vous certain de vouloir supprimer le mot de passe WebDAV?",
    "Are you sure you want to delete Wiki": "\u00cates-vous s\u00fbr de vouloir supprimer Wiki",
    "Are you sure you want to delete the notification ?": "\u00cates-vous certain de vouloir supprimer la notification?",
    "Are you sure you want to delete the selected share link(s) ?": "\u00cates-vous s\u00fbr de vouloir supprimer le(s) lien(s) de partage s\u00e9lectionn\u00e9(s)?",
    "Are you sure you want to delete the selected upload link(s) ?": "\u00cates-vous s\u00fbr de vouloir supprimer le(s) lien(s) d'envoi s\u00e9lectionn\u00e9(s)?",
    "Are you sure you want to delete the selected user(s) ?": "\u00cates-vous certain de vouloir supprimer le(s) utilisateur(s) s\u00e9lectionn\u00e9(s)?",
    "Are you sure you want to delete the share link?": "\u00cates-vous certain de vouloir supprimer ce lien de partage?",
    "Are you sure you want to delete this option?": "\u00cates-vous certain de vouloir supprimer cette option?",
    "Are you sure you want to delete this page?": "Voulez-vous vraiment supprimer les \u00e9l\u00e9ments s\u00e9lectionn\u00e9s?",
    "Are you sure you want to delete {placeholder} ?": "\u00cates-vous certain de vouloir supprimer {placeholder}?",
    "Are you sure you want to delete {placeholder} completely?": "\u00cates-vous certain de vouloir supprimer compl\u00e8tement la biblioth\u00e8que {placeholder}?",
    "Are you sure you want to disconnect?": "\u00cates-vous certain de vouloir vous d\u00e9connecter?",
    "Are you sure you want to leave share Wiki": "\u00cates-vous s\u00fbr de vouloir quitter le partage Wiki",
    "Are you sure you want to remove {placeholder} ?": "\u00cates-vous certain de vouloir retirer {placeholder} de ce groupe?",
    "Are you sure you want to reset the password of {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9initialiser le mot de passe de {placeholder}?",
    "Are you sure you want to restore this library?": "\u00cates-vous certain de vouloir restaurer la biblioth\u00e8que?",
    "Are you sure you want to restore {placeholder}?": "\u00cates-vous certain de vouloir restaurer la biblioth\u00e8que {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9voquer les droits de l\u2019administration de {placeholder}?",
    "Are you sure you want to set {placeholder} as Admin?": "\u00cates-vous certain de vouloir de faire {name} L'administrateur?",
    "Are you sure you want to set {user_placeholder} inactive?": "\u00cates-vous certain de vouloir de inactiver {user_placeholder}?",
    "Are you sure you want to unlink this device?": "\u00cates-vous certain de vouloir supprimer le lien vers l'appareil?",
    "Are you sure you want to unpublish Wiki": "\u00cates-vous s\u00fbr de vouloir d\u00e9publier le wiki?",
    "Are you sure you want to unshare {placeholder} ?": "\u00cates-vous certain de vouloir annuler le partage {placeholder}?",
    "At server": "Serveur",
    "Audio": "Audio",
    "Audit Admin": "Administrateur d'audit",
    "Auth Token created": "Token d'authentification cr\u00e9\u00e9",
    "Auth Token deleted": "Le token d'authentification a \u00e9t\u00e9 supprim\u00e9.",
    "Authenticated emails": "E-mails authentifi\u00e9s",
    "Authenticated users": "Utilisateurs authentifi\u00e9s",
    "Auto deletion": "Autosuppression",
    "Automatically delete files that are not modified within certain days:": "Supprimer automatiquement les fichiers qui n'ont pas \u00e9t\u00e9 modifi\u00e9s dans un certain d\u00e9lai :",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar mis \u00e0 jour",
    "Avatar:": "Avatar :",
    "Back": "Retour",
    "Basic": "Basic",
    "Bell Icon": "Ic\u00f4ne de cloche",
    "Besides Write permission, user can also share the library.": "Outre l'autorisation d'\u00e9criture, l'utilisateur peut \u00e9galement partager une biblioth\u00e8que.",
    "Branding": "Image de marque",
    "Broken (please contact your administrator to fix this library)": "Endommag\u00e9e (Veuillez contacter un administrateur afin de r\u00e9parer cette biblioth\u00e8que)",
    "Broken ({repo_id_placeholder})": "({repo_id_placeholder}) endommag\u00e9",
    "By day": "Par jour",
    "By month": "Par mois",
    "By name ascending": "Par nom croissant",
    "By name descending": "Par nom d\u00e9croissant",
    "By quarter": "Par trimestre",
    "By size ascending": "Par taille croissante",
    "By size descending": "Par taille d\u00e9croissante",
    "By time ascending": "Par date ascendante",
    "By time descending": "Par date descendante",
    "By week": "Par semaine",
    "By year": "Par an",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Impossible de copier le dossier %(src)s vers son sous-dossier %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Impossible de d\u00e9placer le dossier  %(src)s vers son sous-dossier %(des)s",
    "Cancel": "Annuler",
    "Cancel All": "Annuler tout",
    "Cannot move parent page to child page": "Impossible de d\u00e9placer une page parent vers une page enfant",
    "Capture information": "Informations de photo",
    "Capture time": "Date de photo",
    "Certificate": "Certificat",
    "Change": "Changer",
    "Change Password": "Changement de mot de passe",
    "Change Password of Library {placeholder}": "Changement du mot de passe de la biblioth\u00e8que {placeholder}",
    "Change cover": "Modifier la couverture",
    "Change group to department": "Convertir le groupe en d\u00e9partement",
    "Change to department": "Convertir en d\u00e9partement",
    "Changes": "Modifications",
    "Checkbox": "Case \u00e0 cocher",
    "Child tags count": "Tag enfant",
    "Choose date": "Choisir une date",
    "Clean": "Nettoyer",
    "Clean invalid share links": "Supprimer les liens de t\u00e9l\u00e9chargement invalides",
    "Clean invalid upload links": "Supprimer les liens d'envoi invalides",
    "Clean succeeded.": "Le nettoyage a r\u00e9ussi.",
    "Cleaned trash": "Vider la corbeille",
    "Clear": "Effacer",
    "Clear Trash": "Vider la corbeille",
    "Clear files in trash and history\uff1a": "Nettoyer les fichiers dans la corbeille et l'historique :",
    "Clear search": "Effacer la recherche",
    "Clear selected": "Effacer la s\u00e9lection",
    "Click to load more": "Cliquer pour charger plus",
    "Clients": "Clients",
    "Close": "Fermer",
    "Close (Esc)": "Fermer (\u00c9chap)",
    "Code": "Code",
    "Collaborator": "Collaborateur",
    "Collapse": "R\u00e9duire tout",
    "Collapse all": "R\u00e9duire tout",
    "Color": "Couleur",
    "Color space": "Espace de couleur",
    "Community Edition": "\u00c9dition communautaire",
    "Compressed": "Comprim\u00e9",
    "Configure Seafile": "Configuration Seafile",
    "Configure your Identity Provider": "Configuration IdP",
    "Confirm": "Confirmer",
    "Confirm Password": "Confirmer le mot de passe",
    "Confirm password": "Confirmer le mot de passe",
    "Connect": "Connecter",
    "Contact Email": "E-mail de contact",
    "Contact Email:": "E-mail de contact :",
    "Contact Information": "Informations de contact",
    "Contact email": "E-mail de contact",
    "Contact information is required.": "Les informations de contact sont n\u00e9cessaires.",
    "Content Scan Records": "Enregistrements de contenu",
    "Convert & Export": "Convertir et exporter",
    "Convert Wiki": "Convertir le wiki",
    "Convert to Markdown": "Convertir en fichier MD",
    "Convert to docx": "Convertir en fichier DOCX",
    "Convert to new Wiki": "Convertir en un nouveau wiki",
    "Convert to sdoc": "Convertir en fichier SDOC",
    "Convert with ONLYOFFICE": "Convertir avec ONLYOFFICE",
    "Converting": "Conversion",
    "Converting, please wait...": "La conversion est en cours. Veuilez vous patienter.",
    "Converting...": "La conversion est en cours ...",
    "Copied": "Copi\u00e9",
    "Copied link to clipboard": "Le lien a \u00e9t\u00e9 copi\u00e9 dans le presse-papier.",
    "Copy": "Copier",
    "Copy failed": "La copy a \u00e9chou\u00e9.",
    "Copy link": "Copier le lien",
    "Copy selected": "Copier la s\u00e9lection",
    "Copy selected item(s) to:": "Copier les dossiers/fichiers s\u00e9lectionn\u00e9s vers :",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copiez le certificat de l'IdP et collez-le ici. Le format du certificat est comme suit:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copiez la valeur TXT et ajoutez-la aux param\u00e8tres DNS de votre domaine. Cliquez ensuite sur le bouton pour lancer la v\u00e9rification de la propri\u00e9t\u00e9 du domaine. Il faut v\u00e9rifier la propri\u00e9t\u00e9 du domaine avant d'utiliser l'authentification unique.",
    "Copy {num} items": "Copier {num} \u00e9l\u00e9ments",
    "Copy {placeholder} to": "Copier {placeholder} \u00e0",
    "Copyright Infringement": "Violation du droit d'auteur",
    "Count": " Nombre de vues",
    "Cover": "Couverture",
    "Create": "Cr\u00e9er",
    "Create At": "Cr\u00e9\u00e9 le",
    "Create Group": "Cr\u00e9er un groupe",
    "Create Library": "Cr\u00e9er une biblioth\u00e8que",
    "Create Report": "Cr\u00e9er un rapport",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Cr\u00e9er un valeur TXT pour confirmer la propri\u00e9t\u00e9 de votre domaine.",
    "Create a new tag": "Cr\u00e9er un nouveau tag",
    "Create top department": "Ajouter un d\u00e9partement sup\u00e9rieur",
    "Created": "Cr\u00e9\u00e9",
    "Created At": "Cr\u00e9\u00e9 le",
    "Created Files": "Fichiers cr\u00e9\u00e9s",
    "Created draft": "Brouillon cr\u00e9\u00e9",
    "Created file": "Fichier cr\u00e9\u00e9",
    "Created folder": "Dossier cr\u00e9\u00e9",
    "Created group {group_name}": "Groupe {group_name} cr\u00e9\u00e9",
    "Created library": "Biblioth\u00e8que cr\u00e9\u00e9e",
    "Created library {library_name} with {owner} as its owner": "Biblioth\u00e8que {library_name} cr\u00e9\u00e9e par {owner} en tant que propri\u00e9taire",
    "Created time": "Date de cr\u00e9ation",
    "Created {n} files": "Les {n} sont cr\u00e9\u00e9s",
    "Creator": "Cr\u00e9ateur",
    "Current Connected Devices": "Appareils actuellement connect\u00e9s",
    "Current Library": "Biblioth\u00e8que courante",
    "Current Path: ": "Chemin d'acc\u00e8s actuel : ",
    "Current Version": "Version ",
    "Current page": "Page actuelle",
    "Current password": "Mot de passe actuel",
    "Current password cannot be blank": "Le mot de passe actuel ne peut \u00eatre vide",
    "Current path: ": "Chemin d'acc\u00e8s actuel : ",
    "Custom CSS": "CSS personnalis\u00e9",
    "Custom properties": "Propri\u00e9t\u00e9s personnalis\u00e9es",
    "Custom sharing permissions": "Droits de partage personnalis\u00e9s",
    "Customer Portal": "Portail Client",
    "Customize URL": "Personnaliser l'URL",
    "DNS TXT Value": "Valeur TXT",
    "Daily Admin": "Administrateur du jour",
    "Database": "Utilisateurs",
    "Date": "Date",
    "Date Invalid.": "Date invalide.",
    "Day": "Jour",
    "Decrypt document": "D\u00e9crypter le document",
    "Default": "D\u00e9faut",
    "Default Admin": "Administrateur par d\u00e9faut",
    "Delete": "Supprimer",
    "Delete Account": "Supprimer le compte",
    "Delete Department": "Supprimer le d\u00e9partement",
    "Delete Expired Invitations": "Supprimer les invitations expir\u00e9es",
    "Delete File": "Supprimer le fichier",
    "Delete Folder": "Supprimer le dossier",
    "Delete Group": "Supprimer un groupe",
    "Delete Institution": "Supprimer une institution",
    "Delete Library": "Supprimer une biblioth\u00e8que",
    "Delete Member": "Supprimer le membre",
    "Delete Notification": "Supprimer une notification",
    "Delete Organization": "Supprimer l'organisation",
    "Delete Password": "Supprimer le mot de passe",
    "Delete T&C": "Supprimer T&C",
    "Delete Time": "Date de suppression",
    "Delete User": "Supprimer un utilisateur",
    "Delete Users": "Supprimer des utilisateurs",
    "Delete WebDAV Password": "Supprimer le mot de passe WebDAV",
    "Delete Wiki": "Supprimer le Wiki",
    "Delete department": "Supprimer le d\u00e9partment",
    "Delete file": "Supprimer le fichier",
    "Delete files from this device the next time it comes online.": "Supprimer les fichiers de cet appareil la prochaine fois qu'il est en ligne.",
    "Delete folder": "Supprimer le dossier",
    "Delete group": "Supprimer le groupe",
    "Delete page": "Supprimer la page",
    "Delete property": "Supprimer la propri\u00e9t\u00e9",
    "Delete selected": "Supprimer la s\u00e9lection",
    "Delete share link": "Supprimer le lien de partage",
    "Delete share links": "Supprimer les liens de partage",
    "Delete tag": "Supprimer le tag",
    "Delete tags": "Supprimer les tags",
    "Delete upload links": "Supprimer les liens d'envoi",
    "Deleted": "Supprim\u00e9",
    "Deleted Libraries": "Biblioth\u00e8ques supprim\u00e9es",
    "Deleted Time": "Date de suppression",
    "Deleted directories": "Dossiers supprim\u00e9s",
    "Deleted draft": "Brouillon supprim\u00e9",
    "Deleted file": "Fichier supprim\u00e9",
    "Deleted files": "Fichiers supprim\u00e9s",
    "Deleted folder": "Dossier supprim\u00e9",
    "Deleted group {group_name}": "Groupe {group_name} supprim\u00e9",
    "Deleted library": "Supprimer une biblioth\u00e8que",
    "Deleted library {library_name}": "Biblioth\u00e8que {library_name} supprim\u00e9e",
    "Deleted option": "Option supprim\u00e9e",
    "Deleted user %s": "L'utilisater  %s a \u00e9t\u00e9 supprim\u00e9.",
    "Deleted user {user}": "Utilisateur {user} supprim\u00e9",
    "Department ID": "ID du d\u00e9partement",
    "Department renamed": "Le d\u00e9partement a \u00e9t\u00e9 renomm\u00e9.",
    "Departments": "D\u00e9partements",
    "Description": "Description",
    "Description generated": "Une description a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e.",
    "Description is required": "La description est n\u00e9cessaire.",
    "Desktop": "Bureau",
    "Detail": "D\u00e9tail",
    "Details": "D\u00e9tails",
    "Device": "Appareil",
    "Device Name": "Nom de l'appareil",
    "Device make": "Mod\u00e8le d'appareil",
    "Device model": "Mod\u00e8le d'appareil",
    "Devices": "Appareils",
    "Diagram": "Diagramme",
    "Dimensions": "Dimensions",
    "Direct download link": "Lien de t\u00e9l\u00e9chargement direct",
    "Direct download link is copied to the clipboard.": "Lien de t\u00e9l\u00e9chargement direct a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Disable SAML user email / password login": "D\u00e9sactiver la connexion avec nom d'utilisateur/mot de passe pour les utilisateurs SAML",
    "Disable Two-Factor Authentication": "D\u00e9sactiver l'authentification \u00e0 deux facteurs",
    "Disable sync with any folder": "D\u00e9sactiver la synchronisation avec n'importe quel dossier",
    "Disable user clean trash": "D\u00e9sactiver le vidage de la corbeille par l'utilisateur",
    "Disconnect": "D\u00e9connecter",
    "Display files": "Afficher les fichiers",
    "Do not automatically delete files": "Ne pas supprimer les fichiers automatiquement",
    "Do you really want to turn off OCR? Existing OCR results will be deleted.": "\u00cates-vous s\u00fbr de vouloir d\u00e9sactiver l'OCR? Tous les r\u00e9sultats existants OCR seront supprim\u00e9s.",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "\u00cates-vous s\u00fbr de vouloir d\u00e9sactiver les propri\u00e9t\u00e9s \u00e9tendues? Tous les propri\u00e9t\u00e9s \u00e9tendues existantes seront supprim\u00e9es.",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "\u00cates-vous s\u00fbr de vouloir d\u00e9sactiver la reconnaissance faciale? Tous les r\u00e9sultats de la reconnaissance seront supprim\u00e9s.",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "\u00cates-vous s\u00fbr de vouloir d\u00e9sactiver les tags? Tous les tags existants seront supprim\u00e9s.",
    "Document": "Document",
    "Document convertion failed.": "\u00c9chec de conversion du document.",
    "Document keywords": "Mots cl\u00e9s du document",
    "Domain verified": "Le domaine a \u00e9t\u00e9 v\u00e9rifi\u00e9.",
    "Don't ignore": "Ne pas ignorer",
    "Don't keep history": "Ne pas conserver d'historique",
    "Don't replace": "Ne pas remplacer",
    "Don't send emails": "Ne pas envoyer d'e-mails",
    "Don't show empty values": "Ne pas afficher les valeurs vides",
    "Done": "Fait",
    "Down": "Decroissant",
    "Download": "T\u00e9l\u00e9charger",
    "Download an example file": "T\u00e9l\u00e9charger un fichier d'exemple",
    "Download and upload": "T\u00e9l\u00e9chargement et envoi",
    "Drag and drop files or folders here.": "Glisser-d\u00e9poser des fichiers et dossiers",
    "Duplicate": "Dupliquer",
    "Duplicate page": "Dupliquer la page",
    "Edit": "Modifier",
    "Edit format settings": "Modifier les param\u00e8tres de format",
    "Edit labels": "\u00c9diter les \u00e9tiquettes",
    "Edit metadata properties": "Modifier les propri\u00e9t\u00e9s des metadonn\u00e9es",
    "Edit multiple select": "Modifier la s\u00e9lection multiple",
    "Edit on cloud and download": "\u00c9diter dans le cloud et t\u00e9l\u00e9charger",
    "Edit on cloud only": "\u00c9dition dans le cloud uniquement",
    "Edit permission": "\u00c9diter un droit",
    "Edit single select": "Modifier la s\u00e9lection unique",
    "Edit succeeded": "L'\u00e9dition a r\u00e9ussi.",
    "Edit succeeded.": "La modification a \u00e9t\u00e9 enregistr\u00e9e.",
    "Edit tag": "Modifier le tag",
    "Email": "E-mail",
    "Email Domain": "Domaine e-mail",
    "Email Notification": "Notification par e-mail",
    "Email is invalid.": "L'adresse e-mail n'est pas valide",
    "Email notification updated": "La notification par e-mail a \u00e9t\u00e9 mise \u00e0 jour.",
    "Emails": "e-mails",
    "Emails, separated by ','": "E-mails, s\u00e9par\u00e9 par \",\"",
    "Emojis": "\u00c9mojis",
    "Empty": "Vide",
    "Enable OCR": "Activer l'OCR",
    "Enable Two-Factor Authentication": "Activer l'authentification \u00e0 deux facteurs",
    "Enable branding CSS": "Custom CSS",
    "Enable departments feature": "Activer les d\u00e9partements",
    "Enable extended properties": "Activer les propri\u00e9t\u00e9s \u00e9tendues",
    "Enable face recognition to identify people in your photos.": "Activer la reconnaissance faciale pour identifier les personnes sur vos photos",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Acc\u00e9dez \u00e0 l'administration syst\u00e8me pour ajouter des conditions d'utilisation, que tous les utilisateurs devront accepter.",
    "Enable tags to add tags to files and search files by tags.": "Activer les tags pour ajouter des tags aux fichiers et rechercher des fichiers par tags.",
    "Enable terms and conditions": "Activer la fonctionalit\u00e9 conditions d'utilisation",
    "Enable two factor authentication": "Activer l'authentification \u00e0 deux facteurs",
    "Enable users to clean trash": "Autoriser les utilisateurs \u00e0 vider la corbeille",
    "Enable users to share libraries to any groups in the system.": "Autoriser les utilisateurs \u00e0 partager des biblioth\u00e8ques avec n'importe quel groupe du syst\u00e8me.",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "Autoriser le partage avec tous les groupes",
    "Encrypt": "Chiffrer",
    "Encrypted library": "Biblioth\u00e8que crypt\u00e9e",
    "End date": "Date de fin",
    "Enter characters to start searching": "Taper pour lancer la recherche",
    "Error": "Erreur",
    "Errors": "Erreurs",
    "European": "Europ\u00e9en",
    "Exact date": "Date exacte",
    "Exit Institution Admin": "Quitter l'administration de l'organisation",
    "Exit Organization Admin": "Quitter l'administration de l'organisation",
    "Exit System Admin": "Quitter l'administration syst\u00e8me",
    "Expand": "Afficher tout",
    "Expand all": "Afficher tout",
    "Expiration": "Expiration",
    "Expiration date": "Date d'expiration",
    "Expiration days": "Jours d'expiration",
    "Expiration time": "D\u00e9lai d'expiration",
    "Expired": "Expir\u00e9",
    "Expired at": "Expire \u00e0 ",
    "Export": "Exporter",
    "Export Excel": "Exporter vers Excel",
    "Export as docx": "Exporter en fichier DOCX",
    "Export as zip": "Exporter en archive ZIP",
    "Export options": "Exporter les options",
    "Export tags": "Exporter des tags",
    "Exporting": "L'exportation est en cours ...",
    "Exporting...": "L'exportation est en cours ...",
    "Exposure time": "Dur\u00e9e d'exposition",
    "Extended properties": "Propri\u00e9t\u00e9s \u00e9tendues",
    "Extended properties are being built.": "Les propri\u00e9t\u00e9s sont en cours de r\u00e9alisation.",
    "Extension Prompts": "Messages d'extension",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Les extensions des fichiers textes peuvent \u00eatre pr\u00e9visualis\u00e9s en ligne, chaque suffixe est s\u00e9par\u00e9 par une virgule.",
    "Extract file detail": "Extraire les d\u00e9tails du fichier",
    "Extract file details": "Extraire le d\u00e9tail du fichier",
    "Extracting file details by AI...": "Les d\u00e9tails du fichier sont extrait par AI...",
    "Extracting text by AI...": "Le texte est extrait par l'IA...",
    "F number": "Ouverture",
    "Face recognition": "Reconnaissance faciale",
    "Failed": "\u00c9chec",
    "Failed imported options": "L'importation des options a \u00e9chou\u00e9.",
    "Failed to add linked tags": "L'ajout des tags li\u00e9s a \u00e9chou\u00e9.",
    "Failed to add people photos": "L'ajout des photos a \u00e9chou\u00e9.",
    "Failed to add tags": "L'ajout des tags a \u00e9chou\u00e9.",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "\u00c9chec de l'ajout {email_placeholder} : {error_msg_placeholder}",
    "Failed to convert {name}.": "La conversion de {name} a \u00e9chou\u00e9.",
    "Failed to copy %(name)s": "\u00c9chec de la copie de %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Impossible de copier %(name)s et %(amount)s autre(s) \u00e9l\u00e9ment(s).",
    "Failed to copy %(name)s.": "\u00c9chec de la copie de %(name)s",
    "Failed to copy files to another library.": "Impossible de copier les fichiers vers une autre biblioth\u00e8que.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Le fichier %(virus_file) dans la biblioth\u00e8que %(library) n'a pu \u00eatre supprim\u00e9 : %(error_msg)",
    "Failed to delete linked tags": "La suppression des tags li\u00e9s a \u00e9chou\u00e9.",
    "Failed to delete property": "La suppression de la priopri\u00e9t\u00e9 a \u00e9chou\u00e9.",
    "Failed to delete records": "La suppression des enregistrement a \u00e9chou\u00e9.",
    "Failed to delete tags": "La suppression des tags a \u00e9chou\u00e9.",
    "Failed to delete {name}": "Impossible de supprimer {name} ",
    "Failed to delete {name} and {n} other items.": "\u00c9chec de la suppression de {nom} ainsi que {n} autres \u00e9l\u00e9ments",
    "Failed to delete {name}.": "Impossible de supprimer {name}.",
    "Failed to download. The total size of the files exceeded the limit.": "Le t\u00e9l\u00e9chargement a \u00e9chou\u00e9. La taille totale des fichiers depasse la limite.",
    "Failed to duplicate file": "La duplication du fichier a \u00e9chou\u00e9.",
    "Failed to duplicate folder": "La duplication du dossier a \u00e9chou\u00e9.",
    "Failed to duplicate page": "La duplication de la page a \u00e9chou\u00e9.",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "L'exportation a \u00e9chou\u00e9. V\u00e9rifiez si la taille des pi\u00e8ces jointes au tableau d\u00e9passe la limite.",
    "Failed to extract file details": "L'extraction des d\u00e9tails du fichier a \u00e9chou\u00e9.",
    "Failed to extract text": "L'extraction du texte a \u00e9chou\u00e9",
    "Failed to generate description": "La g\u00e9n\u00e9ration d'une description a \u00e9chou\u00e9.",
    "Failed to generate file tags": "La g\u00e9n\u00e9ration des tags de fichier a \u00e9chou\u00e9.",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Le fichier %(virus_file) dans la biblioth\u00e8que %(library) n'a pas pu \u00eatre supprim\u00e9 : %(error_msg)",
    "Failed to import tags. Please reupload.": "L'importation des tags a \u00e9chou\u00e9. Veuillez r\u00e9essayer.",
    "Failed to insert property": "L'insertion de la propri\u00e9t\u00e9 a \u00e9chou\u00e9.",
    "Failed to merge tags": "La fusion des tags a \u00e9chou\u00e9.",
    "Failed to modify filter": "La modification du filtre a \u00e9chou\u00e9.",
    "Failed to modify group": "La modification du groupement a \u00e9chou\u00e9.",
    "Failed to modify hidden properties": "La modification des propri\u00e9t\u00e9s masqu\u00e9es a \u00e9chou\u00e9.",
    "Failed to modify people name": "La modification du nom de la personne a \u00e9chou\u00e9.",
    "Failed to modify property data": "La modification des donn\u00e9es de la propri\u00e9t\u00e9 a \u00e9chou\u00e9.",
    "Failed to modify property order": "La modification de l'ordre de la propri\u00e9t\u00e9 a \u00e9chou\u00e9.",
    "Failed to modify records": "La modifications des enregistrements a \u00e9chou\u00e9.",
    "Failed to modify settings": "La modification des param\u00e8tres a echou\u00e9.",
    "Failed to modify sort": "La modification du tri a \u00e9chou\u00e9.",
    "Failed to modify tags": "La modification des tags a \u00e9chou\u00e9.",
    "Failed to move %(name)s and %(amount)s other item(s).": "Impossible de d\u00e9placer %(name)s et %(amount)s autre(s) \u00e9l\u00e9ment(s).",
    "Failed to move %(name)s.": "\u00c9chec du d\u00e9placement de %(name)s",
    "Failed to move file": "Le deplacement du fichier a \u00e9chou\u00e9.",
    "Failed to move files to another library.": "Impossible de d\u00e9placer les fichiers vers une autre biblioth\u00e8que.",
    "Failed to move folder": "Le deplacement du dossier a \u00e9chou\u00e9.",
    "Failed to move {name}.": "\u00c9chec du d\u00e9placement de {name}.",
    "Failed to remove people photos": "La suppression des photos a \u00e9chou\u00e9.",
    "Failed to rename property": "Le changement du nom de la propri\u00e9t\u00e9 a \u00e9chou\u00e9.",
    "Failed to restore records": "La restauration des enregistrements a \u00e9chou\u00e9.",
    "Failed to restore tags": "La restauration des tags a \u00e9chou\u00e9.",
    "Failed to restore {name}": "\u00c9chec de la restauration de {nom}",
    "Failed to restore {name} and {n} other items": "\u00c9chec de la restauration de {nom} ainsi que {n} autres \u00e9l\u00e9ments",
    "Failed to save": "\u00c9chec de la sauvegarde du fichier",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "\u00c9chec de l'envoi \u00e0 {email_placeholder}: {errorMsg_placeholder}",
    "Failed to set people cover photo": "La d\u00e9finition de la photo de couverture a \u00e9chou\u00e9.",
    "Failed to unshare {name}": "Impossible de supprimer le partage de {name}",
    "Failed to upload {file_name}.": "\u00c9chec de l\u2019envoi du fichier {file_name}. ",
    "Failed. Please check the network.": "\u00c9chec. Veuillez v\u00e9rifier le r\u00e9seau.",
    "Favicon": "Favicon",
    "Favorites": "Favoris",
    "File": "Fichier",
    "File Access": "Acc\u00e8s fichier",
    "File Operations": "Op\u00e9rations de fichiers",
    "File Scan": "Analyse de fichier",
    "File Update": "Mise \u00e0 jour fichier",
    "File Upload": "Importer un fichier",
    "File Uploading...": "L'importation du fichier est en cours ...",
    "File already exists.": "Le fichier existe d\u00e9j\u00e0.",
    "File collaborators": "Collaborateurs de fichier",
    "File count": "Nombre de fichiers",
    "File details": "D\u00e9tails du fichier",
    "File details extracted": "Les d\u00e9tails du fichier ont \u00e9t\u00e9 extrait.",
    "File download is disabled: the share link traffic of owner is used up.": "Le t\u00e9l\u00e9chargement du fichier est d\u00e9sactiv\u00e9 : le trafic du propri\u00e9taire du lien de partage est d\u00e9pass\u00e9.",
    "File expire time": "Date d'expiration du fichier",
    "File extension white list": "Liste blanche des extensions de fichiers",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Liste blanche d'extensions de fichiers pour le t\u00e9l\u00e9chargement de fichiers via l'interface web et l'API. Par exemple, \"md;txt;docx\". Vide signifie qu'il n'y a pas de limite.",
    "File extensions can only be {placeholder}.": "Les extensions de fichiers ne peuvent \u00eatre {placeholder}.",
    "File is locked by others.": "Le fichier est verrouill\u00e9 par d'autres utilisateurs.",
    "File name": "Nom de fichier",
    "File owner": "Propri\u00e9taire du fichier",
    "File rate": "Classement du fichier",
    "File reviewer": "R\u00e9dacteur de fichier",
    "File size is too large.": "Le fichier est trop volumineux.",
    "File size should be smaller than {max_size_placeholder}.": "La taille du fichier doit \u00eatre inf\u00e9rieure \u00e0 {max_size_placeholder}.",
    "File status": "Statut du fichier",
    "File suffix": "Suffixe du fichier",
    "File too large": "Le fichier est trop volumineux.",
    "File type": "Type de fichier",
    "Files": "Fichiers",
    "Files and folders": "Fichiers et dossiers",
    "Filter": "Filtrer",
    "Filters": "Filtres",
    "Find": "Trouver",
    "Find a tag": "Rechercher un tag",
    "Find modifiers": "Rechercher les \u00e9diteurs",
    "Focal length": "Distance focale",
    "Fold": "Masquer",
    "Fold the sidebar": "Masquer le menu lat\u00e9ral",
    "Folder": "Dossier",
    "Folder Permission": "Droits sur le dossier",
    "Folder does not exist.": "Le r\u00e9pertoire n\u2019existe pas.",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "Les droits sur le dossier ne sont effectives que lorsque la biblioth\u00e8que est partag\u00e9e avec des utilisateurs ou des groupes. Ils sont utilis\u00e9 pour affiner les droits d'acc\u00e8s des sous-dossiers.",
    "Folders": "Dossiers",
    "Force password change": "Changement de mot de passe obligatoire",
    "Force user to change password when account is newly added or reset by admin": "Forcer l'utilisateur \u00e0 modifier le mot de passe lorsque le compte a \u00e9t\u00e9 ajout\u00e9 ou r\u00e9initialis\u00e9 par l'administrateur.",
    "Force user to use SSO login if SAML account is bound": "Forcer la connexion avec SSO lorsqu'un compte SAML est connect\u00e9",
    "Force user to use a strong password when sign up or change password.": "Forcer l'utilisateur \u00e0 utiliser un mot de passe fort lorsqu'il se connecte ou change son mot de passe.",
    "Force users to use password when generating share/upload link.": "Forcer l\u2019utilisateur \u00e0 utiliser un mot de passe pour les liens de t\u00e9l\u00e9chargement/d'envoi.",
    "Format": "Format",
    "Freeze Document": "Geler le document",
    "Freeze user account when failed login attempts exceed limit.": "Geler le compte de l'utilisateur lorsque la limite de tentative de connexion a \u00e9t\u00e9 d\u00e9pass\u00e9e.",
    "Freeze user on login failed": "D\u00e9sactivation du compte utilisateur",
    "Frozen by {name}": "Figu\u00e9 par {name}",
    "Gallery": "Galerie",
    "General information": "Informations g\u00e9n\u00e9rales",
    "Generate": "G\u00e9n\u00e9rer",
    "Generate Link": "G\u00e9n\u00e9rer un lien",
    "Generate description": "G\u00e9n\u00e9rer une description",
    "Generate file tags": "G\u00e9n\u00e9rer des tags de fichiers",
    "Generate links in batch": "G\u00e9n\u00e9rer des liens par lots",
    "Generate share link": "G\u00e9n\u00e9rer un lien de t\u00e9l\u00e9chargement",
    "Generating description by AI...": "La g\u00e9n\u00e9ration d'une description par l'IA est en cours ...",
    "Germany Russia etc": "Allemagne, Russie",
    "Global Address Book": "Carnet d'adresses global",
    "Go to Library": "Aller \u00e0 la biblioth\u00e8que",
    "Greater than or equal to {minDays_placeholder} days": "Sup\u00e9rieur ou \u00e9gal \u00e0 {minDays_placeholder} jours",
    "Grid": "Vignettes",
    "Grid view": "Vue grille",
    "Group": "Groupe",
    "Group Permission": "Droits du groupe",
    "Group Shares": "Partages des groupes",
    "Group by": "Grouper par",
    "Group has been transfered": "Le groupe a \u00e9t\u00e9 transf\u00e9r\u00e9.",
    "Group info": "Informations sur le groupe",
    "Group members": "Membres du groupe",
    "Grouped by 1 property": "Group\u00e9 par 1 propri\u00e9t\u00e9",
    "Grouped by {name_placeholder} properties": "Group\u00e9 par {name_placeholder} propri\u00e9t\u00e9s",
    "Groups": "Groupes",
    "Guest": "Invit\u00e9",
    "Handled": "Suspendu",
    "Help": "Aide",
    "Help and resources": "Aide et ressources",
    "Hide": "Cacher",
    "Hide all": "Masquer tout",
    "Hide properties": "Masquer des propri\u00e9t\u00e9s",
    "History": "Historique",
    "History Setting": "Param\u00e8tres de l'historique",
    "History Versions": "Historique",
    "ID": "ID",
    "IP": "IP",
    "ISO": "International (ISO)",
    "Identifying portraits...": "L'identification des portraits est en cours ...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Si les notifications ne sont pas lues pendant l'heure qui suit, vous recevrez une notification par e-mail.",
    "If the library is shared to another department, the sharing will be kept.": "Si la biblioth\u00e8que est partag\u00e9e avec un autre d\u00e9partment, le partage sera conserv\u00e9.",
    "If the library is shared to another user, the sharing will be kept.": "Si la biblioth\u00e8que est partag\u00e9e avec un autre utilisateur, le partage sera conserv\u00e9.",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "Si une cellule contient plusieurs \u00e9l\u00e9ments, un \u00e9l\u00e9ment est s\u00e9lectionn\u00e9 au hasard et compar\u00e9 \u00e0 la valeur du filtre.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Si activ\u00e9, les clients locaux ne pourront pas synchroniser un dossier en dehors du dossier Seafile par d\u00e9faut.",
    "If you don't have any device with you, you can access your account using backup codes.": "Si vous n'avez aucun appareil avec vous, vous pouvez acc\u00e9dez \u00e0 votre compte avec les codes de sauvegardes.",
    "Ignore": "Ignorer",
    "Ignored": "Ignor\u00e9",
    "Image saved": "L'image a \u00e9t\u00e9 enregistr\u00e9e.",
    "Import Users": "Importer des utilisateurs",
    "Import members": "Importer des members",
    "Import members from a .xlsx file": "Importer des membres depuis un fichier .xlsx",
    "Import options": "Importer des options",
    "Import sdoc": "Importer un fichier SDOC",
    "Import tags": "Importer des tags",
    "Import users": "Importer des utilisateurs",
    "Import users from a .xlsx file": "Importer des utilisateurs depuis un fichier .xlsx",
    "Importing sdoc, please wait...": "L'importation du fichier SDOC est en cours ...",
    "In progress": "En cours",
    "In review": "En cours de r\u00e9vision",
    "Inactive": "Inactif",
    "Info": "Infos",
    "Institution": "Institution",
    "Institution Admin": "Administration de l'organisation",
    "Institutions": "Institutions",
    "Internal Link": "Lien interne",
    "Internal Server Error": "Erreur interne du serveur",
    "Internal link has been copied to clipboard": "Le lien interne a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Invalid destination path": "Chemin de destination invalide",
    "Invalid filename.": "Nom de fichier invalide",
    "Invalid filter": "Filtre invalide",
    "Invalid month, should be yyyymm.": "Le mois est invalide. Veuillez entrer la date au format aaaamm.",
    "Invalid regular expression": "L'expression r\u00e9guli\u00e8re est invalide.",
    "Invisible": "Invisible",
    "Invitations": "Invitations",
    "Invite Guest": "Inviter des personnes",
    "Invite Time": "Heure de l'invitation",
    "Invite users": "Inviter des utilisateurs",
    "Invited at": "Invit\u00e9 \u00e0",
    "Inviter": "Inviter",
    "Is expired": "a expir\u00e9",
    "It is already shared to user": "Elle est d\u00e9j\u00e0 partag\u00e9e avec l'utilisateur.",
    "It is required.": "C'est n\u00e9cessaire.",
    "It may take some time, please wait.": "Cela peut prendre un certain temps, veuillez vous patienter.",
    "Kanban": "Kanban",
    "Keep full history": "Conserver l'historique complet",
    "Keep sharing": "Continuer \u00e0 partager",
    "Keep sign in": "Anmeldung speichern",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (import\u00e9)",
    "Label": "\u00c9tiquette",
    "Label Current State": "\u00c9tiquette \u00e9tat actuel",
    "Labels": "\u00c9tiquettes",
    "Language": "Langue",
    "Language Setting": "Langue",
    "Last Access": "Dernier acc\u00e8s",
    "Last Login": "Derni\u00e8re connexion",
    "Last Update": "Mise \u00e0 jour",
    "Last modification": "Derni\u00e8re modification",
    "Last modified by": "Modifi\u00e9 derni\u00e8rement par",
    "Last modified time": "Modifi\u00e9",
    "Last modifier": "Dernier \u00e9diteur",
    "Leave": "Quitter",
    "Leave Group": "Quitter le groupe",
    "Leave Share": "D\u00e9sactiver le partage",
    "Leave Share Wiki": "Quitter Partager Wiki",
    "Leave group": "Quitter le groupe",
    "Leave this page? The system may not save your changes.": "Quitter la page? Il est possible que le syst\u00e8me n'enregistre pas vos modifications.",
    "Less than or equal to {maxDays_placeholder} days": "Inf\u00e9rieur ou \u00e9gal \u00e0 {maxDays_placeholder} jours",
    "Libraries": "Biblioth\u00e8ques",
    "Library": "Biblioth\u00e8que",
    "Library Type": "Type de biblioth\u00e8que",
    "Library can not be shared to owner.": "La biblioth\u00e8que ne peut pas \u00eatre partag\u00e9e par son propri\u00e9taire",
    "Library history": "Historique de la biblioth\u00e8que",
    "Library password minimum length": "Longueur minimale du mot de passe de la biblioth\u00e8que",
    "Library share permission not found.": "L'autorisation de partage de la biblioth\u00e8que n'a pas \u00e9t\u00e9 trouv\u00e9e.",
    "Limits": "Limites",
    "Link": "Lien",
    "Link has been copied to clipboard": "Le lien a \u00e9t\u00e9 copi\u00e9 dans le presse-papier",
    "Linked Devices": "Appareils li\u00e9s",
    "Links": "Liens",
    "List": "Liste",
    "List view": "Vue liste",
    "List your account in global address book, so that others can find you by typing your name.": "Inscrivez votre compte dans le carnet d'adresses global, ainsi les autres pourront vous trouver en saisissant votre nom.",
    "Load all": "Charger tous",
    "Loaded 50,000 records.": "50 000 lignes ont \u00e9t\u00e9 charg\u00e9es.",
    "Loading": "Chargement en cours ...",
    "Location": "Emplacement",
    "Lock": "Verrouiller",
    "Log out": "Se d\u00e9connecter",
    "Login": "Se connecter",
    "Login attempt limit": "Limite de tentative de connexion",
    "Login background image": "Image de fond de connexion",
    "Logo": "Logo",
    "Logo updated": "Le logo a \u00e9t\u00e9 mis \u00e0 jour.",
    "Logs": "Logs",
    "Long text": "Texte mis en forme",
    "Manage group members": "Gestion des membres du groupe",
    "Manage members": "G\u00e9rer les membres",
    "Map": "Carte",
    "Mark all as read": "Marquer comme lu",
    "Mark all read": "Tout marquer comme lu",
    "Max": "Maximum",
    "Member": "Membre",
    "Members": "Membres",
    "Merge tags": "Fusionner les tags",
    "Merge tags to:": "Fusionner les tags \u00e0:",
    "Message": "Message",
    "Message (optional):": "Message (optionnel) : ",
    "Migrate User": "Migrer un utilisateur",
    "Mobile": "Mobile",
    "Modification Details": "D\u00e9tails de la modification",
    "Modified": "Modifi\u00e9",
    "Modified by": "Modifi\u00e9 par",
    "Modified by:": "Modifi\u00e9 par:",
    "Modified files": "Fichiers modifi\u00e9s",
    "Modifier": "Modificateur",
    "Modify": "Modifier",
    "Modify includes modify file, move/rename file and folder": "Modifier inclut la modification de fichier, le d\u00e9placement ou renommage de fichier et dossier",
    "Modify name": "Modifier le nom",
    "Month": "Mois",
    "Month:": "Mois:",
    "Monthly User Traffic": "Trafic mensuel de l'utilisateur",
    "More": "Plus",
    "More operations": "Plus d'actions",
    "Move": "D\u00e9placer",
    "Move file": "D\u00e9placer le fichier",
    "Move folder": "D\u00e9placer le dossier",
    "Move selected item(s) to:": "D\u00e9placer les dossiers/fichiers s\u00e9lectionn\u00e9s vers :",
    "Move {num} items": "D\u00e9placer {num} \u00e9l\u00e9ments",
    "Move {placeholder} to": "D\u00e9placer {placeholder} vers ",
    "Moved file": "Fichier d\u00e9plac\u00e9",
    "Moved folder": "Dossier d\u00e9plac\u00e9",
    "Multiple select": "S\u00e9lection multiple",
    "My Activities": "Mes activit\u00e9s",
    "My Libraries": "Mes biblioth\u00e8ques",
    "My Wikis": "Mes wikis",
    "Name": "Nom",
    "Name already exists": "Le nom existe d\u00e9j\u00e0.",
    "Name cannot be double dots": "Le nom ne peut pas \u00eatre double points.",
    "Name cannot be empty": "Le nom ne peut pas \u00eatre vide.",
    "Name cannot contain backslash": "Le nom ne doit pas contenir de barre oblique inverse ( \\ ).",
    "Name cannot contain backtick": "Le nom ne doit pas contenir d'accent grave isol\u00e9 ( ` ).",
    "Name cannot contain curly braces": "Le nom ne doit pas contenir d'accolades ( { } ).",
    "Name cannot contain dots": "Le nom ne doit pas contenir de point ( . ).",
    "Name cannot contain slash": "Le nom ne doit pas contenir de barre oblique ( / ).",
    "Name is required": "Le nom est n\u00e9cessaire.",
    "Name is required.": "Le nom est n\u00e9cessaire.",
    "Name or ID": "Nom ou ID",
    "Name should be string": "Le nom doit \u00eatre une cha\u00eene de caract\u00e8res.",
    "Name should not include '/'.": "Le nom ne peut inclure '/'.",
    "Name updated": "Le nom a \u00e9t\u00e9 mis \u00e0 jour.",
    "Name(optional)": "Nom (optionnel)",
    "Network error": "Erreur r\u00e9seau",
    "New": "Cr\u00e9er",
    "New Department": "Nouveau d\u00e9partement",
    "New Department Library": "Nouvelle librairie d\u00e9partementale",
    "New Excel File": "Nouveau fichier Excel",
    "New File": "Nouveau fichier",
    "New Folder": "Nouveau dossier",
    "New Group": "Nouveau groupe",
    "New Library": "Nouvelle biblioth\u00e8que",
    "New Markdown File": "Nouveau fichier Markdown",
    "New Password": "Nouveau mot de passe",
    "New Password Again": "Mot de passe \u00e0 nouveau",
    "New PowerPoint File": "Nouveau fichier PowerPoint",
    "New SeaDoc File": "Nouveau dossier SeaDoc",
    "New Sub-department": "Nouveau sous-d\u00e9partement",
    "New Tag": "Nouveau tag",
    "New Whiteboard File": "Nouveau fichier tableau blanc",
    "New Wiki name": "Nom du nouveau wiki",
    "New Word File": "Nouveau fichier Word",
    "New category": "Nouvelle cat\u00e9gorie",
    "New child tag": "Nouveau tag enfant",
    "New directories": "Nouveaux dossiers",
    "New file name": "Nouveau nom de fichier",
    "New files": "Nouveaux fichiers",
    "New folder": "Nouveau dossier",
    "New folder name": "Nouveau nom de dossier",
    "New page": "Nouvelle page",
    "New password": "Nouveau mot de passe",
    "New password cannot be the same as old password": "Le nouveau mot de passe ne peut pas \u00eatre identique \u00e0 l'ancien.",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "Le nouveau mot de passe a \u00e9t\u00e9 envoy\u00e9 sur l'adresse e-mail {mail}. Veuillez v\u00e9rifier votre boite e-mail. Si vous ne recevez pas le nouveau mot de passe, veuillez v\u00e9rifier que votre e-mail est bien configur\u00e9.",
    "New password is too short": "Le nouveau mot de passe est trop court",
    "New passwords don't match": "Les nouveaux mots de passe ne correspondent pas",
    "New tag": "Nouveau tag",
    "New view": "Nouvelle vue",
    "Next": "Suivant",
    "Next (Right arrow key)": "Suivant (Fl\u00e8che droite)",
    "Next modification": "Modification suivante",
    "No Admin login logs": "Aucun journal de connexion administrateur",
    "No Admin operation logs": "Aucun journal des op\u00e9rations d'administration",
    "No Wikis": "Aucun wiki",
    "No address found for the given coordinates.": "Aucune adresse n'a \u00e9t\u00e9 trouv\u00e9e pour les coordonn\u00e9es donn\u00e9es.",
    "No categories": "Aucune cat\u00e9gorie",
    "No changes": "Pas de changement",
    "No collaborators": "Aucun collaborateur",
    "No collaborators available": "Aucun collaborateur n'est disponible.",
    "No connected devices": "Appareils d\u00e9connect\u00e9s",
    "No deleted libraries": "Aucune biblioth\u00e8que supprim\u00e9e",
    "No favorites": "Aucun favori",
    "No file": "Aucun fichier",
    "No file access logs": "Aucun journal d'acc\u00e8s aux fichiers",
    "No file update logs": "Aucun journal de mise \u00e0 jour des fichiers",
    "No files": "Aucun fichier",
    "No filters": "Aucun filtre",
    "No folders shared": "Aucun dossier partag\u00e9",
    "No groupings applied to this view.": "Aucun groupment n'est appliqu\u00e9 \u00e0 cette vue.",
    "No groups": "Aucun groupe",
    "No guest invitations": "Aucune invitation d'invit\u00e9",
    "No invitations": "Aucune invitation",
    "No libraries": "Pas de biblioth\u00e8que",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "Aucune biblioth\u00e8que n'a \u00e9t\u00e9 partag\u00e9e directement avec vous. Une biblioth\u00e8que partag\u00e9e peut \u00eatre partag\u00e9e avec une autorisation compl\u00e8te ou restreinte. Si vous avez besoin d'acc\u00e9der \u00e0 une biblioth\u00e8que appartenant \u00e0 un autre utilisateur, demandez \u00e0 ce dernier de partager la biblioth\u00e8que avec vous.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "Aucune biblioth\u00e8que n'a encore \u00e9t\u00e9 partag\u00e9e avec ce groupe. Une biblioth\u00e8que partag\u00e9e avec un groupe peut \u00eatre accessible \u00e0 tous les membres du groupe. Vous pouvez partager une biblioth\u00e8que avec un groupe dans \"Mes biblioth\u00e8ques\". Vous pouvez \u00e9galement cr\u00e9er une nouvelle biblioth\u00e8que \u00e0 partager avec ce groupe en cliquant sur l'\u00e9l\u00e9ment \"Nouvelle biblioth\u00e8que\" dans le menu d\u00e9roulant.",
    "No libraries have been shared with you": "Vous n'avez pas acc\u00e8s aux biblioth\u00e8ques des autres utilisateurs.",
    "No libraries have been shared with you from other servers.": "Aucune biblioth\u00e8que n'a \u00e9t\u00e9 partag\u00e9e avec vous d'un autre serveur.",
    "No libraries shared": "Aucune biblioth\u00e8que partag\u00e9e",
    "No libraries shared with this group": "Aucune biblioth\u00e8que n'est partag\u00e9e avec ce groupe",
    "No linked devices": "Aucun appareil li\u00e9",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Aucun appareil li\u00e9. Vous n'avez pas encore acc\u00e9d\u00e9 \u00e0 vos fichiers avec un client (de bureau ou mobile). Configurez les clients sur vos appareils pour acc\u00e9der plus facilement \u00e0 vos donn\u00e9es.",
    "No login logs": "Aucun journal de connexion",
    "No members": "Pas de membre",
    "No more activities": "Fin des activit\u00e9s",
    "No notifications": "Aucune notification",
    "No option": "Aucune option",
    "No options": "Aucune option",
    "No options available": "Il n'y a pas d'options disponibles.",
    "No permission logs": "Aucun journal de permission",
    "No preview": "Aucun aper\u00e7u",
    "No properties available to be hidden": "Aucune propri\u00e9t\u00e9 disponible pour \u00eatre masqu\u00e9e",
    "No public libraries": "Il n'y a pas de biblioth\u00e8ques publiques.",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "Aucune biblioth\u00e8que publique n'a encore \u00e9t\u00e9 cr\u00e9\u00e9e. Une biblioth\u00e8que publique est accessible \u00e0 tous les utilisateurs. Vous pouvez cr\u00e9er une biblioth\u00e8que publique en cliquant sur l'\u00e9l\u00e9ment \"Ajouter une biblioth\u00e8que\" dans le menu d\u00e9roulant.",
    "No record": "Aucun enregistrement",
    "No result": "Aucun r\u00e9sultat",
    "No results": "Aucun r\u00e9sultat",
    "No results matching": "Aucun r\u00e9sultat correspondant.",
    "No share links": "Aucun lien de t\u00e9l\u00e9chargement",
    "No shared libraries": "Aucune biblioth\u00e8que partag\u00e9e",
    "No sorts": "Aucun tri",
    "No sync errors": "Aucune erreur de synchronisation",
    "No tag": "Aucun tag",
    "No tags": "Aucun tag",
    "No tags available": "Il n'y a pas de tags disponibles.",
    "No terms and conditions": "Aucune condition d'utilisation",
    "No upload links": "Aucun lien d'envoi",
    "No users": "Aucun utilisateur",
    "No version history": "Aucun historique",
    "None": "Aucun(e)",
    "Not allow user to clean library trash": "Ne pas autoriser les utilisateurs \u00e0 vider les corbeilles de la biblioth\u00e8que",
    "Not allow user to create encrypted libraries": "Ne pas autoriser les utilisateurs \u00e0 c\u0155eer des biblioth\u00e8ques chiffr\u00e9es",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Remarque : Les param\u00e8tres sont sauvegard\u00e9s dans une table de base de donn\u00e9es (seahub-db/constance_config). Elles ont une priorit\u00e9 sup\u00e9rieure aux param\u00e8tres des fichiers de configuration.",
    "Notification": "Notification",
    "Notification Detail": "D\u00e9tail de la notification",
    "Notifications": "Notifications",
    "Notifications of collaboration": "Notification de collaboration",
    "Notifications of file changes": "Notification de modification de fichiers",
    "Number": "Nombre",
    "Number of days ago": "il y a tels jours",
    "Number of days from now": "dans tels jours",
    "Number of days that keep user sign in.": "Laisser l'utilisateur connect\u00e9 pendant un nombre de jours.",
    "Number of groups": "Nombre de groupes",
    "Number of links": "Nombre de liens",
    "OCR": "Reconnaissance optique de caract\u00e8res (OCR)",
    "OCR result": "R\u00e9sultat OCR",
    "Off": "D\u00e9sactiv\u00e9",
    "Office Suite": "Suite bureautique",
    "Old Password": "Ancien mot de passe",
    "Old Wikis": "Anciens wikis",
    "On": "Activ\u00e9",
    "One month ago": "Il y a un mois",
    "One month from now": "Dans un mois",
    "One week ago": "Il y a une semaine",
    "One week from now": "Dans une semaine",
    "Online Preview": "Pr\u00e9visualisation en ligne",
    "Online Read-Only": "Lecture seule en ligne",
    "Online Read-Only folder": "Dossier en ligne en Lecture seule",
    "Online Read-Only library": "Biblioth\u00e8que en ligne en Lecture seule",
    "Online Read-Write": "Lecture-\u00c9criture en ligne",
    "Online Read-Write folder": "Dossier en ligne en Lecture-\u00c9criture",
    "Online Read-Write library": "Biblioth\u00e8que en ligne en Lecture-\u00c9criture",
    "Online view is not applicable to this file format": "L'aper\u00e7u en ligne n'est pas disponible pour de type de fichier",
    "Only Show": "Afficher uniquement",
    "Only files": "Uniquement des fichiers",
    "Only folders": "Uniquement des dossiers",
    "Only keep a period of history:": "Ne conserver qu'une p\u00e9riode de l'historique :",
    "Only pictures": "Uniquement des images",
    "Only videos": "Uniquements des vid\u00e9os",
    "Open file in new tab": "Ouvrir le fichier dans un nouvel onglet",
    "Open folder in new tab": "Ouvrir le dossier dans un nouvel onglet",
    "Open in new tab": "Ouvrir dans un nouvel onglet",
    "Open parent folder": "Ouvrir dossier parent",
    "Open via Client": "Ouvrir avec le client",
    "Operation": "Op\u00e9ration",
    "Operation succeeded.": "Action r\u00e9ussie.",
    "Operations": "Actions",
    "Optional": "Optionnel",
    "Options imported": "Les options ont \u00e9t\u00e9 import\u00e9es.",
    "Or": "ou",
    "Organization": "Organisation",
    "Organization Admin": "Administration de l'organisation",
    "Organizations": "Organisations",
    "Original path": "Chemin d'acc\u00e8s original",
    "Other": "Autre",
    "Other Libraries": "Autres biblioth\u00e8ques",
    "Others": "Autres",
    "Out of quota.": "Quota d\u00e9pass\u00e9.",
    "Outdated": "D\u00e9pass\u00e9",
    "Owned Libraries": "Biblioth\u00e8ques personnelles",
    "Owner": "Propri\u00e9taire",
    "Owner can use admin panel in an organization, must be a new account.": "Le propri\u00e9taire peut utiliser le panneau d'administration dans une organisation et doit \u00eatre un nouveau compte.",
    "Packaging...": "Paquetage ...",
    "Page name": "Nom de page",
    "Page {name_placeholder} deleted.": "La page {name_placeholder} a \u00e9t\u00e9 supprim\u00e9e.",
    "Pages": "Pages",
    "Parent folder": "Dossier parent",
    "Parent tags": "Tag parent",
    "Password": "Mot de passe",
    "Password again": "Mot de passe (\u00e0 nouveau)",
    "Password cannot be blank": "Le mot de passe ne peut pas \u00eatre vide",
    "Password is too short": "Le mot de passe est trop court",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "Le mot de passe doit comporter au moins 8 caract\u00e8res et contenir diff\u00e9rents types de caract\u00e8res : lettres majuscules, lettres minuscules, chiffres et caract\u00e8res sp\u00e9ciaux.",
    "Password removed": "Le mot de passe a \u00e9t\u00e9 supprim\u00e9.",
    "Password reset": "R\u00e9initialisation du mot de passe",
    "Password set": "Le mot de passe a \u00e9t\u00e9 d\u00e9fini.",
    "Password strength": "Robustesse du mot de passe",
    "Password strength should be strong or very strong": "La robustesse du mot de passe doit \u00eatre forte ou tr\u00e8s forte.",
    "Password updated": "Le mot de passe a \u00e9t\u00e9 mis \u00e0 jour.",
    "Passwords do not match.": "Les mots de passe ne correspondent pas.",
    "Passwords don't match": "Les mots de passe ne correspondent pas",
    "Path": "Chemin",
    "People": "Personne",
    "Per 4 hours": "Toutes les 4 heures",
    "Per day": "Tous les jours",
    "Per hour": "Toutes les heures",
    "Per week": "Toutes les semaines",
    "Permission": "Droit",
    "Permission denied": "Autorisation refus\u00e9e",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Autorisation refus\u00e9e. Veuillez essayer {placeholder-left} de vous connecter \u00e0 nouveau. {placeholder-right}.",
    "Permission name": "Nom du droit",
    "Person image": "Image de la personne",
    "Picture": "Photo",
    "Pictures and videos": "Images et vid\u00e9os",
    "Platform": "Plateforme",
    "Please check the network.": "Veuillez v\u00e9rifier le r\u00e9seau.",
    "Please choose a .sdoczip file.": "Veuillez choisir un fichier .sdoczip",
    "Please choose a .xlsx file.": "Veuillez choisir un fichier .xlsx",
    "Please choose an image file.": "Veuillez s\u00e9lectionner un fichier image.",
    "Please enter 1 or more character": "Saisir un 1 caract\u00e8re ou plus ",
    "Please enter a new password": "Veuillez entrer un nouveau mot de passe",
    "Please enter a non-negative integer": "Veuillez introduire un int\u00e9grateur non-n\u00e9gatif",
    "Please enter a password.": "Entrez un mot de passe.",
    "Please enter a positive integer": " Entrez un nombre entier positif.",
    "Please enter an integer bigger than 1 as number of links.": "Entrez un nombre entier sup\u00e9rieur \u00e0 0.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Veuillez saisir un nombre entier inf\u00e9rieur ou \u00e9gal \u00e0 {nombre_max} comme nombre de liens.",
    "Please enter days": "Veuillez entrer un nombre de jours",
    "Please enter password": "Entrez un mot de passe",
    "Please enter the new password again": "Veuillez entrer le nouveau mot de passe encore une fois",
    "Please enter the old password": "Veuillez entrer l'ancien mot de passe",
    "Please enter the password again": "Entrez \u00e0 nouveau un mot de passe",
    "Please input at least an email.": "Veuillez entrer au moins une adresse e-mail.",
    "Please select a file": "Veuillez s\u00e9lectionner un fichier",
    "Please select a library or folder first.": "Veuillez d'abord s\u00e9lectionner une biblioth\u00e8que ou un dossier.",
    "Please select a library to share.": "Veuillez s\u00e9lectionner la biblioth\u00e8que \u00e0 partager.",
    "Please select an expiration time": "Veuillez s\u00e9lectionner une date d'expiration",
    "Please upload no more than {maxFiles} files at a time.": "Veuillez ne pas envoyer plus de {maxFiles} fichiers \u00e0 la fois.",
    "Predefined properties": "Proprit\u00e9t\u00e9s pr\u00e9d\u00e9finies",
    "Preparing to upload...": "Pr\u00e9paration de l'envoi..",
    "Preset hide properties": "Propri\u00e9t\u00e9s masqu\u00e9es pr\u00e9d\u00e9finies",
    "Preview and download": "Pr\u00e9visualiser et t\u00e9l\u00e9charger",
    "Preview online": "Pr\u00e9visualisation en ligne",
    "Preview only": "Aper\u00e7u uniquement",
    "Previous": "Pr\u00e9c\u00e9dent",
    "Previous (Left arrow key)": "Pr\u00e9c\u00e9dent (Fl\u00e8che gauche)",
    "Print": "Imprimer",
    "Print document": "Imprimer le document",
    "Professional Edition": "\u00c9dition professionnelle",
    "Profile": "Profil",
    "Profile Setting": "Profil",
    "Properties": "Propri\u00e9t\u00e9s",
    "Properties to display on the card": "Propri\u00e9t\u00e9s \u00e0 afficher",
    "Property name": "Nom de la propri\u00e9t\u00e9",
    "Publish": "Publier",
    "Publish Wiki": "Publier le wiki",
    "Published": "Publi\u00e9",
    "Quota": "Quota",
    "Quota is invalid.": "Le quota n'est pas valide.",
    "Rate": "Classement",
    "Read-Only": "Lecture seulement",
    "Read-Only folder": "Dossier en Lecture-Seulement",
    "Read-Only library": "Biblioth\u00e8que en lecture seule",
    "Read-Write": "Lecture - \u00c9criture",
    "Read-Write folder": "Dossier en Lecture-\u00c9criture",
    "Read-Write library": "Biblioth\u00e8que en lecture / \u00e9criture",
    "Really want to delete this group?": "Voulez-vous vraiment supprimer ce groupe?",
    "Really want to delete your account?": "Voulez-vous vraiment supprimer ce compte?",
    "Really want to leave this group?": "Voulez-vous vraiment quitter ce groupe?",
    "Recently Used": "R\u00e9cemment utilis\u00e9",
    "Recognizing portraits. Please refresh the page later.": "La reconnaissance optique est cours. Veuillez rafra\u00eechir la page plus tard.",
    "Refresh": "Rafraichir",
    "Refresh the view": "Rafra\u00eechir la vue.",
    "Remaining": "Restant",
    "Remove": "Supprimer",
    "Remove Member": "Retirer un membre",
    "Remove from this group": "Supprimer du group",
    "Removed all items from trash.": "Supprimer tous les \u00e9l\u00e9ments de la corbeille.",
    "Removed items older than {n} days from trash.": "Supprimer de la corbeille les \u00e9l\u00e9ments datant de plus {n} jours.",
    "Rename": "Renommer",
    "Rename Department": "Renommer un d\u00e9partement",
    "Rename File": "Renommer le fichier",
    "Rename Folder": "Renommer le dossier",
    "Rename Group": "Renommer le groupe",
    "Rename Wiki": "Renommer le wiki",
    "Rename file": "Renommer le fichier",
    "Rename folder": "Renommer le dossier",
    "Rename group to": "Renommer le groupe en ",
    "Rename property": "Renommer la propri\u00e9t\u00e9",
    "Renamed file": "Fichier renomm\u00e9",
    "Renamed folder": "Dossier renomm\u00e9",
    "Renamed library": "Biblioth\u00e8que renomm\u00e9e",
    "Renamed or Moved files": "Fichiers renomm\u00e9s ou d\u00e9plac\u00e9s",
    "Renaming {name} failed": "Impossible de renommer {name}",
    "Replace": "Remplacer",
    "Replace file {filename}?": "Remplacer le fichier {filename}?",
    "Replacing it will overwrite its content.": "Choisir \"Remplacer\" \u00e9crase le fichier existant.",
    "Report Abuse": "Signaler un abus",
    "Reporter": "Auteur du rapport",
    "Reports": "Rapports",
    "Required at least three letters.": "Trois lettres requises au minimum.",
    "Reset": "R\u00e9initialiser",
    "Reset Password": "R\u00e9initialiser du mot de passe",
    "Reset WebDAV Password": "R\u00e9initialiser le mot de passe WebDAV",
    "Reset library password": "R\u00e9initialiser le mot de passe de la biblioth\u00e8que",
    "ResetPwd": "R\u00e9initialisation du mot de passe",
    "Resetting user's password, please wait for a moment.": "R\u00e9initialisation du mot de passe de l'utilisateur, veuillez patienter un instant.",
    "Restore": "Restaurer",
    "Restore Library": "Restaurer une biblioth\u00e8que",
    "Restored 1 item": "1 \u00e9l\u00e9ment a \u00e9t\u00e9 restaur\u00e9.",
    "Restored file": "Fichier restaur\u00e9",
    "Restored folder": "Dossier restaur\u00e9",
    "Restored library": "Biblioth\u00e8que restaur\u00e9e",
    "Restored {name}": "{name} a \u00e9t\u00e9 restaur\u00e9",
    "Restored {name} and {n} other items": "{nom} a \u00e9t\u00e9 restaur\u00e9 ainsi que {n} autres \u00e9l\u00e9ments",
    "Result": "R\u00e9sultat",
    "Retry": "R\u00e9essayer",
    "Retry All": "R\u00e9essayer tout",
    "Revoke": "R\u00e9voquer",
    "Revoke Access": "Acc\u00e8s r\u00e9voqu\u00e9",
    "Revoke Admin": "R\u00e9voquer un administrateur",
    "Role": "R\u00f4le",
    "Rotate": "Pivoter",
    "SAML config": "Configuration SAML",
    "SAML config updated": "La configuration SAML a \u00e9t\u00e9 mise \u00e0 jour.",
    "Satellite": "Satellite",
    "Save": "Sauvegarder",
    "Save Selected Items": "Enregistrer la s\u00e9lection",
    "Save as ...": "Enregistrer sous ...",
    "Save to:": "Enregistrer sous :",
    "Saving...": "Sauvegarde ...",
    "Scan the QR code to view the shared content directly": "Scanner le code QR pour pour afficher directement le contenu partag\u00e9",
    "SeaTable integration": "Int\u00e9gration SeaTable",
    "Seafile": "Seafile",
    "Search": "Chercher",
    "Search Groups": "Cherche groupes",
    "Search Libraries": "Rechercher des biblioth\u00e8ques",
    "Search Organizations": "Rechercher des organisations",
    "Search Users": "Rechercher des utilisateurs",
    "Search collaborator": "Rechercher des collaborateurs",
    "Search collaborators": "Rechercher des collaborateurs",
    "Search files": "Recherce de fichiers",
    "Search files in this library": "Recherche de fichiers dans cette biblioth\u00e8que",
    "Search group members": "Rechercher des membres du groupe",
    "Search groups": "Recherche de groupes",
    "Search groups by name": "Cherche de groupes par nom",
    "Search libraries by name or ID": "Recherche de biblioth\u00e8ques par nom ou par identifiant",
    "Search libraries by owner": "Recherche de biblioth\u00e8ques par propri\u00e9taire",
    "Search option": "Rechercher une option",
    "Search organizations": "Rechercher des organisations",
    "Search property": "Recherche de propri\u00e9t\u00e9s",
    "Search property types": "Recherche de type de propri\u00e9t\u00e9",
    "Search results visited recently": "R\u00e9sultats de recherche visit\u00e9s r\u00e9cemment",
    "Search tag": "Rechercher un tag",
    "Search users": "Cherche d'utilisateurs par nom",
    "Search users...": "Recherche d'utilisateurs ...",
    "Select": "S\u00e9lectionner",
    "Select All": "S\u00e9lectionner tout",
    "Select File": "S\u00e9lectionner un fichier",
    "Select Image": "S\u00e9lectionner l'image",
    "Select Tags": "S\u00e9lectionner des tags",
    "Select a color": "S\u00e9lectionner une couleur",
    "Select a department": "S\u00e9lectionner un d\u00e9partement",
    "Select a office suite": "S\u00e9lectionner une suite bureautique",
    "Select a server": "S\u00e9lectionner un serveur",
    "Select a user": "S\u00e9lectionner un utilisateur",
    "Select a user as admin": "D\u00e9finir un utilisateur en tant qu'administrateur",
    "Select all": "S\u00e9lectionner tous",
    "Select all items": "S\u00e9lectionner tous les \u00e9l\u00e9ments",
    "Select an option": "S\u00e9lectionner une optio",
    "Select collaborators": "S\u00e9lectionner des collaborateurs",
    "Select group members": "S\u00e9lectionner des membres du groupe",
    "Select libraries to share": "S\u00e9lectionnez la biblioth\u00e8que \u00e0 partager",
    "Select option(s)": "S\u00e9lectionner une/des option(s)",
    "Select shared users": "S\u00e9lectionner les utilisateurs avec un partage",
    "Select this item": "S\u00e9lectionner l'\u00e9l\u00e9ment",
    "Select up to 50 files": "S\u00e9lectionner d'un maximum de 50 fichiers",
    "Selected": "S\u00e9lectionn\u00e9",
    "Send": "Envoyer",
    "Send activation Email after user registration.": "Envoyer l'e-mail d'activation apr\u00e8s l'inscription de l'utilisateur.",
    "Send activation email": "Registrierung per E-Mail best\u00e4tigen",
    "Send to:": "Envoyer \u00e0 :",
    "Sending new password...": "Envoi du nouveau mot de passe..",
    "Sending...": "Envoi ...",
    "Server": "Serveur",
    "Server Version: ": "Version du serveur : ",
    "Set": "D\u00e9finir",
    "Set Admin": "D\u00e9finir un administrateur",
    "Set Contact Email": "D\u00e9finir l'e-mail de contact",
    "Set Download Rate Limit": "D\u00e9finir le rate limiting t\u00e9l\u00e9chargement",
    "Set Login ID": "D\u00e9finir un identifiant de connexion",
    "Set Name": "D\u00e9finir un nom",
    "Set Password": "D\u00e9finir un mot de passe",
    "Set Quota": "D\u00e9finir le quota",
    "Set Upload Rate Limit": "D\u00e9finir le rate limiting envoi",
    "Set WebDAV Password": "D\u00e9finir le mot de passe WebDAV",
    "Set access scope": "D\u00e9finir la port\u00e9e de l'acc\u00e8s",
    "Set as cover photo": "D\u00e9finir comme photo de couverture",
    "Set child tags": "D\u00e9finir les tags enfants",
    "Set max number of members": "D\u00e9finir le nombre maximum de membres",
    "Set password": "D\u00e9finir le mot de passe",
    "Set permission": "D\u00e9finir la permission",
    "Set permission of {placeholder}": "D\u00e9finir le droit de {placeholder}",
    "Set quota": "D\u00e9finir le quota",
    "Set to current": "Activer",
    "Set user contact email": "D\u00e9finir l'e-mail de contact de l'utilisateur",
    "Set user default quota": "D\u00e9finir le quota par d\u00e9faut de l'utilisateur",
    "Set user inactive": "Inactiver l'utilisateur",
    "Set user name": "D\u00e9finir un nom d'utilisateur",
    "Set user quota": "D\u00e9finir le quota de l'utilisateur",
    "Setting library history is disabled by Admin.": "La modification des param\u00e8tres de l'historique de la biblioth\u00e8que a \u00e9t\u00e9 d\u00e9sactiv\u00e9e par l'administrateur.",
    "Settings": "Param\u00e8tres",
    "Share": "Partager",
    "Share Admin": "Gestion des partages",
    "Share From": "Partag\u00e9 par",
    "Share Link": "Lien de t\u00e9l\u00e9chargement",
    "Share Link Traffic": "Trafic des liens de partage",
    "Share Links": "Liens de t\u00e9l\u00e9chargement",
    "Share To": "Partag\u00e9e avec",
    "Share To:": "Partag\u00e9e avec :",
    "Share existing libraries": "Partagez une biblioth\u00e8que existante",
    "Share link download": "Lien de t\u00e9l\u00e9chargement partag\u00e9",
    "Share link is copied to the clipboard.": "Le lien de t\u00e9l\u00e9chargement a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Share link upload": "Lien d'envoi partag\u00e9",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Les liens de partage ne peuvent pas \u00eatre g\u00e9n\u00e9r\u00e9s parce que \"Invisible\", \"Lecture-\u00c9criture en ligne\" ou \"Lecture seule en ligne\" est d\u00e9fini pour vous sur certains dossiers de la biblioth\u00e8que",
    "Share to group": "Partage avec un groupe",
    "Share to other server": "Partage avec un autre serveur",
    "Share to user": "Partage avec un utilisateur",
    "Share/upload link force password": "Mot de passe obligatoire pour les liens",
    "Share/upload link password minimum length": "Longeur minimale du mot de passe pour les liens",
    "Share/upload link password strength level": "Robustesse du mot de passe pour les liens",
    "Shared By": "Partag\u00e9 par",
    "Shared Libraries": "Biblioth\u00e8ques partag\u00e9es",
    "Shared Links": "Liens partag\u00e9s",
    "Shared by:": "Partag\u00e9 par : ",
    "Shared by: ": "Partag\u00e9 par : ",
    "Shared with all": "Partag\u00e9e avec tout le monde",
    "Shared with me": "Partag\u00e9e avec moi",
    "Show": "Afficher",
    "Show Codes": "Afficher les codes",
    "Show all": "Afficher tout",
    "Show changes": "Afficher les modifications",
    "Show property names": "Afficher les noms de propri\u00e9t\u00e9s",
    "Side Nav Menu": "Menu de navigation sur le c\u00f4t\u00e9",
    "Single select": "S\u00e9lection unique",
    "Site name": "Nom du site",
    "Site name used in email sending": "Le nom du site utilis\u00e9 dans l'envoi d'e-mails",
    "Site title": "Titre du site",
    "Site title shown in a browser tab": "D\u00e9finir un titre visible dans l'onglet du navigateur",
    "Size": "Taille",
    "Social Login": "Connexion r\u00e9seau social",
    "Sort": "Trier",
    "Sort ascending": "Tri croissant",
    "Sort descending": "Tri d\u00e9croissant",
    "Space Used": "Espace utilis\u00e9",
    "Space Used / Quota": "Espace utilis\u00e9 / Quota",
    "Space used": "Espace utilis\u00e9",
    "Specific people with email address": "Personnes sp\u00e9cifiques identifi\u00e9es par addresse e-mail",
    "Specific users in the team": "Utilisateurs sp\u00e9cifiques dans l'\u00e9quipe",
    "Star": "Favoris",
    "Start date": "Date de d\u00e9but",
    "Statistic": "Statistiques",
    "Status": "Statut",
    "Status: enabled": "Status : activ\u00e9",
    "Storage": "Stockage",
    "Storage Backend": "Syst\u00e8me de stockage",
    "Storage Used": "Espace utilis\u00e9",
    "Strong password": "Mot de passe fort",
    "Style": "Style",
    "Submit": "Soumettre",
    "Success": "Succ\u00e8s",
    "Successfully added %s.": " %s a \u00e9t\u00e9 ajout\u00e9.",
    "Successfully added label(s) for library {placeholder}": "Le(s) \u00e9tiquettes(s) de la biblioth\u00e8que {placeholder} ont \u00e9t\u00e9 ajout\u00e9s.",
    "Successfully added {email_placeholder}": "{email_placeholder} a \u00e9t\u00e9 ajout\u00e9.",
    "Successfully change office suite.": "La suit bureautique a \u00e9t\u00e9 chang\u00e9.",
    "Successfully change the group": "Le group a \u00e9t\u00e9 chang\u00e9.",
    "Successfully changed library password.": "Le mot de passe de la biblioth\u00e8que a \u00e9t\u00e9 modifi\u00e9.",
    "Successfully cleaned all errors.": "Toutes les erreurs ont \u00e9t\u00e9 effac\u00e9es avec succ\u00e8s.",
    "Successfully cleaned invalid share links.": "Tous les liens de t\u00e9l\u00e9chargement invalides ont \u00e9t\u00e9 supprim\u00e9s.",
    "Successfully cleaned invalid upload links.": "Tous les liens d'envoi invalides ont \u00e9t\u00e9 supprim\u00e9s.",
    "Successfully cleared trash.": "La corbeille a \u00e9t\u00e9 vid\u00e9e.",
    "Successfully converted the file.": "Le fichier a \u00e9t\u00e9 converti.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s et %(amount)s autres \u00e9l\u00e9ments ont \u00e9t\u00e9 copi\u00e9s.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s et un autre \u00e9l\u00e9ment ont \u00e9t\u00e9 copi\u00e9s.",
    "Successfully copied %(name)s.": "%(name)s a \u00e9t\u00e9 copi\u00e9.",
    "Successfully copied files to another library.": "Fichiers copi\u00e9s vers une autre biblioth\u00e8que avec succ\u00e8s.",
    "Successfully deleted 1 item": "1 objet a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted 1 item.": "1 objet a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted 1 share link": "1 lien de partage a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully deleted 1 upload link": "1 lien d'envoi a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted 1 user.": "1 utilisateur a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully deleted {name}": "{name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {name} and {n} other items": "{name} et {n} autres \u00e9l\u00e9ments ont \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {name} and {n} other items.": "Suppression r\u00e9ussie de {nom} ainsi que {n} autres \u00e9l\u00e9ments.",
    "Successfully deleted {name}.": "{name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {number_placeholder} share links": "{number_placeholder} liens de partage ont \u00e9t\u00e9 supprim\u00e9s avec succ\u00e8s.",
    "Successfully deleted {number_placeholder} upload links": "{number_placeholder} liens d'envoi ont \u00e9t\u00e9 supprim\u00e9s.",
    "Successfully deleted {user_number_placeholder} users.": " {user_number_placeholder} utilisateurs ont \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully edited labels.": "Les \u00e9tiquettes ont \u00e9t\u00e9 \u00e9dit\u00e9es.",
    "Successfully invited %(email) and %(num) other people.": "%(email) et %(num) ont \u00e9t\u00e9 invit\u00e9.",
    "Successfully invited %(email).": "%(email) a \u00e9t\u00e9 invit\u00e9.",
    "Successfully modified permission.": "Permission modifi\u00e9e.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s et %(amount)s autres \u00e9l\u00e9ments ont \u00e9t\u00e9 d\u00e9plac\u00e9s.",
    "Successfully moved %(name)s and 1 other item.": " %(name)s et un autre \u00e9l\u00e9ment ont \u00e9t\u00e9 d\u00e9plac\u00e9s.",
    "Successfully moved %(name)s.": " %(name)s ont \u00e9t\u00e9 d\u00e9plac\u00e9.",
    "Successfully moved files to another library.": "Fichiers d\u00e9plac\u00e9s vers une autre biblioth\u00e8que avec succ\u00e8s.",
    "Successfully moved {name}.": " {name} a \u00e9t\u00e9 d\u00e9plac\u00e9.",
    "Successfully removed {placeholder}.": "Le membre {placeholder} a \u00e9t\u00e9 retir\u00e9.",
    "Successfully restored the library {library_name}.": "La biblioth\u00e8que a \u00e9t\u00e9 restaur\u00e9e.",
    "Successfully restored the library.": "La biblioth\u00e8que a \u00e9t\u00e9 restaur\u00e9e.",
    "Successfully restored.": "Restaur\u00e9.",
    "Successfully revoke the admin permission of %s": "Permissions administrateur de %s supprim\u00e9es.",
    "Successfully revoked access of user {placeholder}.": "L'acc\u00e8s de l'utilisateur {placeholder} a \u00e9t\u00e9 r\u00e9voqu\u00e9.",
    "Successfully revoked the admin permission of {placeholder}.": "Les droits de l\u2019administration de {placeholder} ont \u00e9t\u00e9 r\u00e9voqu\u00e9s.",
    "Successfully saved": "Sauvegard\u00e9",
    "Successfully sent to {placeholder}": "Envoy\u00e9 \u00e0 {placeholder}",
    "Successfully set %s as admin.": "%s d\u00e9fini en tant qu'administrateur.",
    "Successfully set it.": "La modification a \u00e9t\u00e9 enregistr\u00e9e.",
    "Successfully set library history.": "Les param\u00e8tres de l'historique de la biblioth\u00e8que ont \u00e9t\u00e9 enregistr\u00e9s.",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} a \u00e9t\u00e9 ajout\u00e9e aux favoris.",
    "Successfully transferred the group.": "Le groupe a \u00e9t\u00e9 transf\u00e9r\u00e9.",
    "Successfully transferred the library.": "La biblioth\u00e8que a \u00e9t\u00e9 transf\u00e9r\u00e9e.",
    "Successfully unlinked %(name)s.": "%(name)s a \u00e9t\u00e9 d\u00e9li\u00e9 avec succ\u00e8s.",
    "Successfully unlinked the device.": "L'appareil a \u00e9t\u00e9 d\u00e9li\u00e9 avec succ\u00e8s.",
    "Successfully unshared library {placeholder}": "Le partage de {placeholder} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully unshared {name}": "Le partage de {name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} a \u00e9t\u00e9 supprim\u00e9e des favoris.",
    "Suggestion": "Suggestion",
    "Switch sort mode": "Modifier le tri",
    "Switch to plain text editor": "Basculer en \u00e9diteur de texte plein",
    "Switch to rich text editor": "Basculer en \u00e9diteur de texte enrichi",
    "Switch view mode": "Modifier la vue",
    "Sync": "Synchroniser",
    "Sync Download": "T\u00e9l\u00e9chargement synchronis\u00e9",
    "Sync Traffic": "Trafic pour la synchronisation",
    "Sync Upload": "Envoi synchronis\u00e9",
    "System": "Syst\u00e8me",
    "System Admin": "Administration syst\u00e8me",
    "System Info": "Informations syst\u00e8me",
    "System settings updated": "Les param\u00e8tres du syst\u00e8me ont \u00e9t\u00e9 mis \u00e0 jour.",
    "Table": "Tableau",
    "Tag": "Tag",
    "Tag \"{name}\" already exists.": "Le tag \"{name}\" existe d\u00e9j\u00e0.",
    "Tag not found": "Le tag n'a pas \u00e9t\u00e9 trouv\u00e9.",
    "Tagged Files": "Fichiers tagu\u00e9s",
    "Tags": "Tags",
    "Tags imported": "Les tags ont \u00e9t\u00e9 importes.",
    "Tags language:": "Langue des tags:",
    "Team name": "Nom de l'\u00e9quipe",
    "Template": "Th\u00e8me",
    "Terms": "Conditions",
    "Terms and Conditions": "Conditions d'utilisation",
    "Text": "Texte",
    "Text extracted": "Le texte a \u00e9t\u00e9 extrait.",
    "Text file extensions": "Extensions des fichiers texte",
    "Text is required.": "Le texte est n\u00e9cessaire.",
    "Text wraps": "Renoyer \u00e0 la ligne",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "Le document a une longueur de plus de 100 000 caract\u00e8res. Seuls les 100 000 premiers caract\u00e8res sont enregistr\u00e9s.",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "Le document a une longueur de plus de 100 000 caract\u00e8res et ne peut donc pas \u00eatre enregistr\u00e9.",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "La partie personnalis\u00e9e de l'URL doit comporter entre 5 et 30 caract\u00e8res et ne peut contenir que des lettres et des chiffres ainsi que des traits d'union.",
    "The file is too large. Allowed maximum size is 1MB.": "Le fichier est trop volumineux. La taille maximum autoris\u00e9e est de 1 Mo.",
    "The image could not be previewed.": "L'image ne peut pas \u00eatre pr\u00e9visualis\u00e9e.",
    "The imported options already exists": "Les options import\u00e9es existent d\u00e9j\u00e0.",
    "The imported options are invalid": "Les options import\u00e9es sont invalides.",
    "The imported tag already exists": "Le tag import\u00e9 existe d\u00e9j\u00e0.",
    "The imported tags are invalid": "Les tags import\u00e9s sont invalides.",
    "The least number of characters a share/upload link password should include.": "Le nombre minimum de caract\u00e8res que devrait comporter le mot de passe d'un lien de partage/t\u00e9l\u00e9chargement.",
    "The least number of characters an encrypted library password should include.": "Le nombre minimum de caract\u00e8res qu'un mot de passe de biblioth\u00e8que crypt\u00e9e devrait inclure.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "La robustese (1-4) du mot de passe d'un lien de partage/t\u00e9l\u00e9chargement. Par exemple, '3' signifie que le mot de passe doit comporter au moins 3 des \u00e9l\u00e9ments suivants : chiffres, lettres majuscules, lettres minuscules et autres symboles.",
    "The link is copied to the clipboard.": "Le lien a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "La liste des fichiers ajout\u00e9s, supprim\u00e9s et modifi\u00e9s seront envoy\u00e9s dans votre boite e-mail.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Le nombre maximum de tentatives de connexion \u00e9chou\u00e9es avant que le CAPTCHA n'apparaisse.",
    "The name \"{name}\" is already taken. Please choose a different name.": "Le nom \"{name}\" est d\u00e9j\u00e0 pris.",
    "The next month": "Le mois prochain",
    "The next numbers of days": "Au cours de tels prochains jours",
    "The next week": "La semaine prochaine",
    "The next year": "L'ann\u00e9e prochaine",
    "The owner of this library has run out of space.": "Le propri\u00e9taire de cette biblioth\u00e8que n'a plus assez d'espace libre..",
    "The password is too short.": "Le mot de passe est trop court.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "Le mot de passe est trop faible. Il doit contenir au minimum {passwordStrengthLevel} exemplaires des caract\u00e8res suivant: nombres, majuscules, minuscules et caract\u00e8res sp\u00e9ciaux.",
    "The password will be kept in the server for only 1 hour.": "Le mot de passe est conserv\u00e9 sur le serveur pendant 1 heure.",
    "The past month": "Le mois dernier",
    "The past numbers of days": "Au cours de tels derniers jours",
    "The past week": "La semaine derni\u00e8re",
    "The past year": "L'ann\u00e9e derni\u00e8re",
    "The row is locked and cannot be modified": "La ligne est verrouill\u00e9e et ne peut \u00eatre modifi\u00e9e",
    "There is another option with this name": "Une option portant ce nom existe d\u00e9j\u00e0.",
    "There is another property with this name": "Une propri\u00e9t\u00e9 portant ce nom existe d\u00e9j\u00e0.",
    "There is no information to display.": "Il n'y a pas d'informations \u00e0 afficher.",
    "This file has (apparently) not been accessed yet": "Ce fichier n'a (apparemment) pas encore \u00e9t\u00e9 consult\u00e9",
    "This file has been updated.": "Ce fichier \u00e0 bien \u00e9t\u00e9 mis \u00e0 jour.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "Ce dossier a \u00e9t\u00e9 partag\u00e9 avec le(s) utilisateur(s) {user_amount} et le(s) groupe(s) {group_amount}.",
    "This folder has no content at this time.": "Le r\u00e9pertoire ne poss\u00e8de aucun contenu actuellement.",
    "This is a special group representing a department.": "Groupe sp\u00e9cial repr\u00e9sentant le d\u00e9partement",
    "This is required": "C'est n\u00e9cessaire.",
    "This library has been set to read-only by admin and cannot be updated.": "La biblioth\u00e8que est param\u00e9tr\u00e9e par l\u2019administrateur en lecture seule et en peut pas \u00eatre modifi\u00e9e.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "Cette librairie a \u00e9t\u00e9 partag\u00e9 avec {user_amount} utilisateur(s) et {group_amount} groupe(s).",
    "This library is password protected": "Cette biblioth\u00e8que est prot\u00e9g\u00e9e par un mot de passe",
    "This month": "Ce mois",
    "This operation will not be reverted. Please think twice!": "Cette action est irr\u00e9versible. Veuillez y r\u00e9fl\u00e9chir \u00e0 deux fois !",
    "This property can not be deleted": "Cette propri\u00e9t\u00e9 ne peut pas \u00eatre supprim\u00e9e.",
    "This property does not support sorting": "Cette propri\u00e9t\u00e9 ne peut pas \u00eatre tri\u00e9e.",
    "This property is not editable": "Cette propri\u00e9t\u00e9 n'est pas modifiable.",
    "This user has not created or joined any groups": "L'utilisateur n'a pas \u00e9t\u00e9 cr\u00e9\u00e9 ou n'a rejoint aucun groupe",
    "This week": "Cette semaine",
    "This year": "Cette ann\u00e9e",
    "Thumbnail": "Miniatures",
    "Time": "Heure",
    "Tip: -2 means no limit.": "Astuce : -2 signifie illimit\u00e9.",
    "Tip: 0 means default limit": "Astuce : 0 signifie aucune limite par d\u00e9faut",
    "Tip: 0 means default limit, the unit is MB": "Astuce : 0 signifie la limite par d\u00e9faut; l'unit\u00e9 est le Mo.",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Astuce : un instantan\u00e9 sera g\u00e9n\u00e9r\u00e9 apr\u00e8s chaque modification, qui enregistrera l'\u00e9tat de la biblioth\u00e8que apr\u00e8s la modification.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Conseil : les biblioth\u00e8ques supprim\u00e9es {placeholder} il y a quelques jours seront automatiquement nettoy\u00e9es.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Astuce : Les biblioth\u00e8ques supprim\u00e9es sont automatiquement \u00e9limin\u00e9es du syst\u00e8me {trashReposExpireDays} jours apr\u00e8s la suppression.",
    "Tip: you can search by keyword in name or ID.": "Astuce : vous pouvez effectuer une recherche par mot cl\u00e9 dans le nom ou l'ID.",
    "Tip: you can search by keyword in name.": "Astuce : vous pouvez faire une recherche par mot-cl\u00e9 dans le nom.",
    "Title property": "Propri\u00e9t\u00e9 du titre",
    "Today": "Aujourd'hui",
    "Token": "Token",
    "Token:": "Token :",
    "Tomorrow": "Demain",
    "Too many requests": "Trop de demandes",
    "Total Devices": "Total d'appareils",
    "Total Storage": "Stockage total",
    "Total Traffic": "Trafic total",
    "Total Users": "Utilisateurs totaux",
    "Total users": "Utilisateurs totaux",
    "Traffic": "Trafic",
    "Traffic this month": "Bande passante de ce mois",
    "Transfer": "Transf\u00e9rer ",
    "Transfer Group": "Transf\u00e9rer un groupe",
    "Transfer Group {placeholder} to": "Transf\u00e9rer le groupe {placeholder} \u00e0",
    "Transfer Library": "Transf\u00e9rer une biblioth\u00e8que",
    "Transfer Library {library_name}": "Transf\u00e9rer la biblioth\u00e8que {library_name} ",
    "Transfer group to": "Transf\u00e9rer le groupe \u00e0",
    "Transfer to department": "Transf\u00e9rer au d\u00e9partement ",
    "Transfer to user": "Transf\u00e9rer \u00e0 l'utilisateur ",
    "Transferred group {group_name} from {user_from} to {user_to}": "Le groupe {group_name} a \u00e9t\u00e9 transf\u00e9r\u00e9 de {user_from} \u00e0 {user_to}.",
    "Transferred library {library_name} from {user_from} to {user_to}": "La biblioth\u00e8que {library_name} a \u00e9t\u00e9 transf\u00e9r\u00e9e de {user_from} \u00e0 {user_to}.",
    "Trash": "Corbeille",
    "Turn off": "D\u00e9sactiver",
    "Turn off OCR": "D\u00e9sactiver l'OCR",
    "Turn off extended properties": "D\u00e9sactiver les propri\u00e9t\u00e9s \u00e9tendues",
    "Turn off face recognition": "D\u00e9sactiver la reconnaissance faciale",
    "Turn off tags": "D\u00e9sactiver les tags",
    "Turn on extensible properties and views to experience a new way of managing files": "Activez les propri\u00e9t\u00e9s et les vues extensibles pour d\u00e9couvrir une nouvelle fa\u00e7on de g\u00e9rer les fichiers",
    "Two-Factor Authentication": "Authentification \u00e0 deux facteurs",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "La cl\u00e9 d'authentification \u00e0 deux facteurs n'est pas activ\u00e9e sur votre compte. Activez la cl\u00e9 d'authentification \u00e0 deux facteurs afin d'am\u00e9liorer la s\u00e9curit\u00e9 de votre compte.",
    "Type": "Type",
    "Type characters to start search": "Taper pour lancer la recherche",
    "URL is copied to the clipboard": "L'URL a \u00e9t\u00e9 copi\u00e9e dans le presse-papiers.",
    "URL is required": "L'URL est n\u00e9cessaire.",
    "US": "Am\u00e9ricain",
    "Uncategorized": "Non categoris\u00e9",
    "Undo": "Annuler",
    "Unfold": "Afficher",
    "Unfold the sidebar": "Afficher le menu lat\u00e9ral",
    "Unfreeze Document": "D\u00e9geler le document",
    "Unhandled": "Non g\u00e9r\u00e9",
    "Unknown": "Inconnu",
    "Unknown people": "Personne inconnue",
    "Unlink": "Supprimer",
    "Unlink device": "Supprimer le lien vers l'appareil",
    "Unlock": "D\u00e9verrouiller",
    "Unpublish": "Annuler la publication",
    "Unpublish Wiki": "D\u00e9publier le wiki",
    "Unselect": "D\u00e9s\u00e9lectionner",
    "Unselect all": "D\u00e9s\u00e9lectionner tout",
    "Unselect all items": "D\u00e9s\u00e9lectionner tous les \u00e9l\u00e9ments",
    "Unselect this item": "D\u00e9s\u00e9lectionner l'\u00e9l\u00e9ment",
    "Unshare": "Annuler le partage",
    "Unshare Library": "Biblioth\u00e8que non partag\u00e9e",
    "Unstar": "Supprimer",
    "Untitled": "Sans titre",
    "Unwatch File Changes": "Ne pas observer les changements de fichiers",
    "Up": "Croissant",
    "Update": "Mettre \u00e0 jour",
    "Update Terms and Conditions": "Mettre \u00e0 jour les conditions d'utilisation",
    "Update password": "Mettre \u00e0 jour le mot de passe",
    "Update succeeded.": "Mis \u00e0 jour avec succ\u00e8s.",
    "Updated draft": "Brouillon mis \u00e0 jour",
    "Updated file": "Fichier mis \u00e0 jour",
    "Upgrade to Pro Edition": "Passer \u00e0  l'\u00e9dition professionnelle",
    "Upload": "Importer",
    "Upload Files": "Importer des fichiers",
    "Upload Folder": "Importer un dossier",
    "Upload Link": "Lien d'envoi",
    "Upload Links": "Liens d'envoi",
    "Upload file": "Importer le fichier",
    "Upload files to {folder_name_placeholder}": "Importer les fichiers \u00e0 {folder_name_placeholder}",
    "Upload license": "Importer la license",
    "Upload link is copied to the clipboard.": "Le lien d'envoi a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Uploaded": "Envoy\u00e9",
    "Uploading...": "L'importation est en cours ...",
    "Use custom CSS": "Utiliser un CSS personalis\u00e9",
    "Use information from your Identity Provider to configure Seafile": "Utiliser des informations de votre IdP afin de configurer Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Utiliser la fonction \"Importer/Exporter des tags\" pour transf\u00e9rer rapidement des options. (L'exportation est au format JSON.) En collant une ou plusieurs valeurs copi\u00e9es d'une colone de texte, d'un fichier Excel ou d'un fichier TXT, vous pouvez \u00e9galement ajouter rapidement des options.",
    "Use the import/export function to transfer tags quickly to another library. (The export is in JSON format.)": "Utiliser la fonction \"Importer/Exporter des tags\" pour transf\u00e9rer rapidement des tags vers une autre biblioth\u00e8que. (L'exportation est au format JSON.)",
    "Use these values to configure your Identity Provider": "Utiliser les donn\u00e9es suivantes afin de configurer votre IdP",
    "Used:": "Utilis\u00e9 :",
    "User": "Utilisateur",
    "User Email": "E-mail d'utilisateur",
    "User Permission": "Droits de l'utilisateur",
    "User Shares": "Partages des utilisateurs",
    "User Storage": "Stockage de l'utilisateur",
    "User can not see this folder.": "L'utilisateur ne peut pas voir ce dossier.",
    "User can only view files online via browser. Files can't be downloaded.": "L'utilisateur peut uniquement afficher les fichiers en ligne via un navigateur. Les fichiers ne peuvent pas \u00eatre t\u00e9l\u00e9charg\u00e9s.",
    "User can read, download and sync files.": "Vous pouvez lire, t\u00e9l\u00e9charger et synchroniser des fichiers.",
    "User can read, write, upload, download and sync files.": "L'utilisateur peut lire, \u00e9crire, envoyer, t\u00e9l\u00e9charger et synchroniser des fichiers.",
    "User can view and edit file online via browser. Files can't be downloaded.": "L'utilisateur peut voir et \u00e9diter un fichier en ligne via un navigateur. Les fichiers ne peuvent pas \u00eatre t\u00e9l\u00e9charg\u00e9s.",
    "User default quota": "Quota d'utilisateur par d\u00e9faut",
    "User default quota updated": "Le quota d'utilisateur par d\u00e9faut a \u00e9t\u00e9 mis \u00e0 jour.",
    "User deleted": "L'utilisateur a \u00e9t\u00e9 supprim\u00e9.",
    "User info updated": "Les informations sur l'utilisateur ont \u00e9t\u00e9 mises \u00e0 jour.",
    "User is already in this group": "Cet utilisateur fait d\u00e9j\u00e0 partie de ce groupe.",
    "User migrate from {user_from} to {user_to}": "L'utilisateur a \u00e9te migr\u00e9 de {user_from} \u00e0 {user_to}.",
    "User not found": "Utilisateur introuvable",
    "User number limit": "Limite du nombre d'utilisateurs",
    "User {user_link} has added you to {group_link}": "L'utilisateur {user_link} vous a ajout\u00e9 \u00e0 {group_link}",
    "Username:": "Nom d'utilisateur :",
    "Users": "Utilisateurs",
    "Verified": "V\u00e9rifi\u00e9",
    "Verify": "V\u00e9rifier",
    "Verify Domain": "V\u00e9rification du domaine",
    "Version": "Version",
    "Version Number": "Num\u00e9ro de version",
    "Version Number is required.": "Le num\u00e9ro de version est n\u00e9cessaire.",
    "Version Number must be a number.": "Le num\u00e9ro de version doit \u00eatre un nombre.",
    "Video": "Vid\u00e9o",
    "View": "Afficher",
    "View Link": "Voir le lien",
    "View Related Snapshot": "Voir l'instantan\u00e9 associ\u00e9",
    "View Snapshot": "Voir l'instantan\u00e9",
    "View all notifications": "Voir toutes les notifications",
    "View original image": "Voir l'image originale",
    "View profile and more": "Voir le profil et plus",
    "View published page": "Voir la page publi\u00e9e",
    "Views": "Vues",
    "Virus": "Virus",
    "Virus File": "Fichier infect\u00e9",
    "Virus Scan": "Recherche de virus",
    "Visit count": "Nombre de visites",
    "Visit old version page": "Visiter l'ancienne page pour l'historique",
    "Visited": "Visit\u00e9",
    "Visits": "Visites",
    "Waiting...": "Veuillez patienter ...",
    "Watch File Changes": "Observer les changements de fichiers",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "T\u00e9l\u00e9chargement Web",
    "Web Traffic": "Trafic Web",
    "Web Upload": "Envoi Web",
    "WebDAV Access": "Acc\u00e8s WebDAV",
    "WebDAV password:": "Mot de passe WebDAV:",
    "WebDAV username:": "Nom d'utilisateur WebDAV:",
    "Welcome to {site_name_placeholder}": "Bienvenue sur {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Voulez-vous recevoir des notifications de collaboration (par ex. partage de biblioth\u00e8que, admission d'un groupe) par e-mail ?",
    "Wiki custom URL deleted": "L'URL personnalis\u00e9e du wiki a \u00e9t\u00e9 supprim\u00e9e.",
    "Wiki owner": "Propri\u00e9taire du wiki",
    "Wiki published": "Wiki publi\u00e9",
    "Wikis": "Wikis",
    "Workspace": "Espace de travail",
    "Wrong password": "Le mot de passe est erron\u00e9",
    "Year": "An",
    "Yesterday": "Hier",
    "You are watching file changes of this library.": "Vous observez les changements de fichiers de cette biblioth\u00e8que.",
    "You can add a Wiki by clicking the \"Add Wiki\" item in the dropdown menu.": "Vous pouvez cr\u00e9er un wiki en cliquant sur l'\u00e9l\u00e9ment \u00ab Ajouter un wiki \u00bb dans le menu d\u00e9roulant.",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Vous pouvez aussi ajouter un utilisateur comme invit\u00e9, qui ne sera pas autoris\u00e9 \u00e0 cr\u00e9er des biblioth\u00e8ques et des groupes.",
    "You can create files quickly": "Vous pouvez cr\u00e9er des fichiers rapidement",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "Vous pouvez cr\u00e9er des biblioth\u00e8ques en cliquant sur l'\u00e9l\u00e9ment \u00ab Nouvelle biblioth\u00e8que \u00bb dans le menu d\u00e9roulant.",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "Vous pouvez saisir plusieurs emails. Un lien d'invitation sera envoy\u00e9 \u00e0 chacun d'entre eux.",
    "You can use this field at login.": "Vous pouvez utiliser ce champ \u00e0 la connexion.",
    "You do not have any Wikis yet.": "Vous n'avez pas encore de wikis.",
    "You do not have permission": "Vous n'avez pas l'autorisation.",
    "You don't have any favorite items yet": "Yous n'avez pas de favoris.",
    "You don't have any share links": "Vous n'avez aucun lien de t\u00e9l\u00e9chargement.",
    "You don't have any upload links": "Vous n'avez aucun lien d'envoi.",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Vous n'avez pas encore acc\u00e9d\u00e9 \u00e0 vos fichiers avec un client (bureau ou mobile). Configurez des clients sur vos appareils pour acc\u00e9der plus confortablement \u00e0 vos donn\u00e9es.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Vous n'avez pas encore ajout\u00e9 de biblioth\u00e8ques, dossiers ou fichiers \u00e0 vos favoris. Un favori permet un acc\u00e8s rapide \u00e0 vos objets les plus fr\u00e9quents. Vous pouvez ajouter une biblioth\u00e8que, dossier ou fichier \u00e0 vos favoris en cliquant sur l'\u00e9toile \u00e0 gauche de son libell\u00e9. ",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "Vous n'avez pas encore cr\u00e9\u00e9 de biblioth\u00e8que. Une biblioth\u00e8que est un contenant permettant d'organiser des dossiers et des fichiers. Une biblioth\u00e8que peut aussi \u00eatre partag\u00e9e avec d'autres utilisateurs et synchronis\u00e9e sur vos appareils. Vous pouvez cr\u00e9er une biblioth\u00e8que en cliquant sur l'\u00e9l\u00e9ment \"Nouvelle biblioth\u00e8que\" dans le menu d\u00e9roulant.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Vous n'avez pas encore g\u00e9n\u00e9r\u00e9 de liens de partage. Un lien de partage peut \u00eatre utilis\u00e9 pour partager des fichiers et des dossiers avec n'importe qui. Vous pouvez g\u00e9n\u00e9rer un lien de partage pour un fichier ou un dossier en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son nom.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Vous n'avez pas encore g\u00e9n\u00e9r\u00e9 de lien d'envoi. Un lien d'envoi permet \u00e0 des utilisateurs anonymes de charger des fichiers dans un dossier ou une biblioth\u00e8que. Vous pouvez g\u00e9n\u00e9rer un lien d'envoi pour un dossier ou une biblioth\u00e8que en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son libell\u00e9. ",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "Vous n'avez supprim\u00e9 aucune biblioth\u00e8que au cours des derniers jours {placeholder}. Une biblioth\u00e8que supprim\u00e9e sera automatiquement nettoy\u00e9e apr\u00e8s cette p\u00e9riode.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "Vous n'avez pas encore invit\u00e9 d'invit\u00e9s. Un invit\u00e9 peut acc\u00e9der aux biblioth\u00e8ques partag\u00e9es par l'interm\u00e9diaire de l'interface web, ce qui permet de collaborer plus efficacement que par des liens. Vous pouvez inviter un invit\u00e9 en cliquant sur l'\u00e9l\u00e9ment \u00ab Inviter un invit\u00e9 \u00bb dans le menu d\u00e9roulant.",
    "You have not shared any folders": "Vous n'avez partag\u00e9 aucun dossier.",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Vous n'avez pas encore partag\u00e9 de dossiers avec d'autres utilisateurs. Vous pouvez partager un dossier avec d'autres utilisateurs en cliquant en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son libell\u00e9.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Vous n'avez encore partag\u00e9 aucune biblioth\u00e8que avec d'autres utilisateurs. Vous pouvez partager une biblioth\u00e8que avec d'autres utilisateurs en cliquant sur l'ic\u00f4ne de partage \u00e0 droite du nom d'une biblioth\u00e8que dans \"Mes biblioth\u00e8ques\".",
    "You have only one backup code remaining.": "Il ne vous reste qu'un seul code de sauvegarde.",
    "You have {num} backup codes remaining.": "Il vous reste {num} codes de sauvegarde.",
    "Your notifications will be sent to this email.": "Vos notifications seront envoy\u00e9es \u00e0 cette adresse e-mail.",
    "ZIP": "ZIP",
    "ZIP Selected Items": "Zipper les \u00e9l\u00e9ments s\u00e9lectionn\u00e9s",
    "Zoom in": "Agrandir",
    "Zoom out": "D\u00e9zoomer",
    "all": "tout",
    "all members": "Tous les membres",
    "contains": "contient",
    "copy": "copier",
    "days": "jours",
    "deleted": "Supprim\u00e9",
    "deleted option": "Option supprim\u00e9e",
    "details": "D\u00e9tails",
    "does not contain": "ne contient pas",
    "email is required": "L'adresse e-mail est n\u00e9cessaire.",
    "freezed": "figu\u00e9e",
    "has all of...": "contient tout",
    "has any of...": "contient au moins une",
    "has none of...": "ne contient aucun",
    "icon": "ic\u00f4ne",
    "in all libraries": "Dans toutes les biblioth\u00e8ques",
    "in this folder": "Das ce dossier",
    "in this library": "Dans cette biblioth\u00e8que",
    "include the current user": "invlure l'utilisateur actuel",
    "is": "est",
    "is after...": "est apr\u00e8s",
    "is any of...": "contient au moins une",
    "is before...": "est avant",
    "is current user's ID": "est l'ID de l'utilisateur actuel",
    "is empty": "est vide",
    "is exactly...": "est exactement",
    "is none of...": "ne contient aucun",
    "is not": "n'est pas",
    "is not empty": "n'est pas vide",
    "is on or after...": "est le ou apr\u00e8s",
    "is on or before...": "est le ou avant",
    "is within...": "est pendant",
    "items": "\u00e9l\u00e9ments",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "sous licence de {placeholder_license_to}, expire le {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "sous licence de {placeholder_license_to}, le service de mise \u00e0 niveau a expir\u00e9 le {placeholder_license_expiration}",
    "locked": "verrouill\u00e9",
    "locked by {name}": "Verrouill\u00e9 par {name}",
    "members": "membres",
    "mm": "mm",
    "name": "nom",
    "not set": "non d\u00e9fini",
    "only show {placeholder}": "N'affichez que {placeholder}",
    "progress": "Progression",
    "s": "s",
    "selected": "s\u00e9lectionn\u00e9",
    "shared by:": "partag\u00e9 par :",
    "show more": "Voir plus",
    "size": "Taille",
    "sorts": "tris",
    "starred": "favoris",
    "state": "\u00c9tat",
    "successfully added user %s.": "L'utilisateur %s a \u00e9t\u00e9 ajout\u00e9.",
    "successfully sent email to %s.": "Un e-mail a \u00e9t\u00e9 envoy\u00e9 \u00e0 %s.",
    "unstarred": "Retir\u00e9 des favoris",
    "xxx cells copied": "xxx cellules ont \u00e9t\u00e9 copi\u00e9es dans le presse-papiers.",
    "xxx cells cut": "xxx cellules ont \u00e9t\u00e9 coup\u00e9es et copi\u00e9es dans le presse-papiers.",
    "xxx cells selected": "xxx cellules s\u00e9lectionn\u00e9es",
    "xxx record": "xxx enregistrement",
    "xxx records": "xxx enregistrements",
    "xxx records selected": "xxx enregistrements s\u00e9lectionn\u00e9s",
    "xxx rows are copied.": "xxx lignes ont \u00e9t\u00e9 copi\u00e9es dans le presse-papiers.",
    "{failed_files_num} file(s) failed to upload": "L'importation de {failed_files_num} fichier(s) a \u00e9chou\u00e9.",
    "{file} and {n} other files": "{file} et {n} autres fichiers",
    "{library_name} Office Suite": "{library_name} Suite bureautique",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} jours",
    "{name_placeholder} cells copied": "{name_placeholder} cellules ont \u00e9t\u00e9 copi\u00e9es dans le presse-papiers.",
    "{name_placeholder} cells cut": "{name_placeholder} cellules ont \u00e9t\u00e9 coup\u00e9es et copi\u00e9es dans le presse-papiers.",
    "{name_placeholder} cells selected": "{name_placeholder} cellules s\u00e9lectionn\u00e9es",
    "{name_placeholder} hidden properties": "{name_placeholder} propri\u00e9t\u00e9s masqu\u00e9es",
    "{name_placeholder} preset hidden properties": "{name_placeholder} prori\u00e9t\u00e9s masqu\u00e9es pr\u00e9d\u00e9finies",
    "{name_placeholder} record": "{name_placeholder} enregistrement",
    "{name_placeholder} records": "{name_placeholder} enregistrements",
    "{name_placeholder} records selected": "{name_placeholder} enregistrements s\u00e9lectionn\u00e9s",
    "{name_placeholder} rows are copied.": "{name_placeholder} lignes ont \u00e9t\u00e9 copi\u00e9es dans le presse-papiers.",
    "{name} rows use this option.": "{name} lignes utilisent cette option.",
    "{number_placeholder} / Page": "{number_placeholder} / Page",
    "{placeholder} API Token": "{placeholder} du token API",
    "{placeholder} Access Log": "Log de l'acc\u00e8s {placeholder}",
    "{placeholder} Folder Permission": "Droits sur le dossier {placeholder}",
    "{placeholder} History Setting": "Param\u00e8tres de l'historique {placeholder}",
    "{placeholder} Modification History": "Historique des modifications de {placeholder} ",
    "{placeholder} Share Admin": "{placeholder} Gestions des partages",
    "{placeholder} Snapshot": "Instantan\u00e9 de {placeholder}",
    "{placeholder} Trash": "Corbeille de {placeholder}",
    "{placeholder} Wiki Trash": "{placeholder} corbeille wiki",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} a annul\u00e9 le partage du dossier {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} a annul\u00e9 le partage de la biblioth\u00e8que {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} a chang\u00e9 le droit sur le dossier {repo_link} en {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} a chang\u00e9 le droit de partage de la biblioth\u00e8que {repo_link} en {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} a partag\u00e9 un r\u00e9pertoire nomm\u00e9e {repo_link} avec le groupe {group_link}. ",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} a partag\u00e9 un r\u00e9pertoire nomm\u00e9e {repo_link} avec vous.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} a partag\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link} avec le groupe {group_link}. ",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} a partag\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link} avec vous.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} organise les fichiers dans des biblioth\u00e8ques. Chaque biblioth\u00e8que peut \u00eatre synchronis\u00e9e et partag\u00e9e s\u00e9par\u00e9ment. Cependant, en tant qu'utilisateur invit\u00e9, vous ne pouvez pas cr\u00e9er de biblioth\u00e8ques.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} organise les fichiers dans des biblioth\u00e8ques. Chaque biblioth\u00e8que peut \u00eatre synchronis\u00e9e et partag\u00e9e s\u00e9par\u00e9ment. Nous avons cr\u00e9\u00e9 une biblioth\u00e8que personnelle pour vous. Vous pourrez cr\u00e9er plus de biblioth\u00e8ques ult\u00e9rieurement.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} fichiers",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "Le(s) utilisateur(s) {userCount} et les biblioth\u00e8ques {repoCount} de cette organisation seront \u00e9galement supprim\u00e9s.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a cr\u00e9\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "L'utilisateur {user} a cr\u00e9\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a cr\u00e9e le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "L'utilisateur {user} a cr\u00e9e le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} has transfered a library named {repo_link} to you.": "{share_from} vous a transf\u00e9r\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "L'utilisateur {user} a renomm\u00e9 le fichier {oldFileName} en {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "L'utilisateur {user} a renomm\u00e9 le dossier {oldFolderName} en {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "L'utilisateur {user} a restaur\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "L'utilisateur {user} a restaur\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "L'utilisateur {user} a mis a jour le fichier {fileName} dans la biblioth\u00e8que {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d.%m.%Y %H:%M:%S",
      "%d.%m.%Y %H:%M:%S.%f",
      "%d.%m.%Y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%d/%m/%y",
      "%d.%m.%Y",
      "%d.%m.%y",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "j N Y H:i",
    "SHORT_DATE_FORMAT": "j N Y",
    "THOUSAND_SEPARATOR": "\u00a0",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

